/* AUTOMATICALLY GENERATED on Fri Dec 16 10:11:03 AUSEDT 2011
 * for ManageSoft release 8.6 (build 8.1978)
 *
 * DO NOT EDIT THIS FILE BY HAND!
 * 
 * Protected by US patents 6,006,034 and 6,360,366.
 * Copyright 2011 ManageSoft Corporation. All rights reserved.
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

USE ManageSoft
GO

PRINT '------------------------'
PRINT 'Creating database tables'
PRINT '------------------------'
GO


PRINT '------------------------'
PRINT 'Creating database views'
PRINT '------------------------'
GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'WiMiMigrationStateByComputer') BEGIN
	DROP VIEW [WiMiMigrationStateByComputer]
END
GO

PRINT 'Creating WiMiMigrationStateByComputer view'
GO
/*
 * $Header$
 *
 * Description
 *	Migration state for each computer
 */

-- Create migration status view
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'WiMiMigrationStateByComputer')
   DROP VIEW WiMiMigrationStateByComputer
GO

CREATE VIEW WiMiMigrationStateByComputer
AS
SELECT
r.SessionName,
CASE
-- Find any installation or policy failures
WHEN r.LastStatus = 'Failure' OR EXISTS (
	SELECT *
	FROM Installation i
	WHERE i.ComputerID = c.ComputerID
	AND i.Result = 'failure'
	AND r.CompleteDateTime IS NOT NULL
)
	THEN 'Migration failed'
-- Check operating system
WHEN (r.CompleteDateTime IS NOT NULL)
	THEN 'Migration succeeded'
ELSE	'Not migrated'
END AS State,
c.ComputerID,
c.ComputerCN,
c.ComputerOUID,
o.OperatingSystemName,
r.LastStatus,
r.LastStep,
r.LastStepDescription,
r.StepCount,
r.StartDateTime,
r.LastDateTime,
r.CompleteDateTime
FROM	RolloutStatusSummary AS r
	INNER JOIN RolloutStatusType AS rt ON r.RolloutStatusTypeID = rt.RolloutStatusTypeID AND rt.[Name] = 'ComputerBuild'
	LEFT OUTER JOIN Computer AS c ON c.ComputerID = r.ComputerID
	LEFT OUTER JOIN OperatingSystem o ON c.OperatingSystemID = o.OperatingSystemID
GO

GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'WiMiImageCaptureStateByComputer') BEGIN
	DROP VIEW [WiMiImageCaptureStateByComputer]
END
GO

PRINT 'Creating WiMiImageCaptureStateByComputer view'
GO
/*
 * $Header$
 *
 * Description
 *	Image capture state for each computer
 */

-- Create image capture state status view
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'WiMiImageCaptureStateByComputer')
   DROP VIEW WiMiImageCaptureStateByComputer
GO

CREATE VIEW WiMiImageCaptureStateByComputer
AS
SELECT
r.SessionName,
CASE
-- Find any installation or policy failures
WHEN r.LastStatus = 'Failure'
	THEN 'ImageCaptureFailed'
WHEN (r.LastStatus = 'Success' AND r.CompleteDateTime IS NOT NULL)
	THEN 'ImageCaptureSucceeded'
ELSE
	'ImageCaptureInProgress'
END AS State,
c.ComputerID,
ISNULL(c.ComputerCN, r.SessionName) AS ComputerCN,
c.ComputerOUID,
o.OperatingSystemName,
r.LastStatus,
r.LastStep,
r.LastStepDescription,
r.StepCount,
r.StartDateTime,
r.LastDateTime,
r.CompleteDateTime,
d.DataImageCaptureLocation,
d.ImageCaptureDateTime
FROM	RolloutStatusSummary AS r
	INNER JOIN RolloutStatusType t ON r.RolloutStatusTypeID = t.RolloutStatusTypeID AND t.[Name] = 'ComputerImageCapture'
	LEFT OUTER JOIN Computer AS c ON c.ComputerID = r.ComputerID
	LEFT OUTER JOIN OperatingSystem o ON c.OperatingSystemID = o.OperatingSystemID
	LEFT OUTER JOIN DataCapture d ON r.SessionName = d.SessionName
GO

GO

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'WiMiDataCaptureStateByComputer') BEGIN
	DROP VIEW [WiMiDataCaptureStateByComputer]
END
GO

PRINT 'Creating WiMiDataCaptureStateByComputer view'
GO
/*
 * $Header$
 *
 * Description
 *	Data capture state for each computer
 */

-- Create data capture status view
IF EXISTS (SELECT TABLE_NAME FROM INFORMATION_SCHEMA.VIEWS
         WHERE TABLE_NAME = 'WiMiDataCaptureStateByComputer')
   DROP VIEW WiMiDataCaptureStateByComputer
GO

CREATE VIEW WiMiDataCaptureStateByComputer
AS
SELECT
r.SessionName,
CASE
-- Find any installation or policy failures
WHEN r.LastStatus = 'Failure'
	THEN 'DataCaptureFailed'
WHEN (r.LastStatus = 'Success' AND r.CompleteDateTime IS NOT NULL)
	THEN 'DataCaptureSucceeded'
ELSE
	'DataCaptureInProgress'
END AS State,
c.ComputerID,
c.ComputerCN,
c.ComputerOUID,
o.OperatingSystemName,
r.LastStatus,
r.LastStep,
r.LastStepDescription,
r.StepCount,
r.StartDateTime,
r.LastDateTime,
r.CompleteDateTime,
d.DataStoreLocation,
d.CaptureDateTime
FROM	RolloutStatusSummary AS r
	INNER JOIN RolloutStatusType t ON r.RolloutStatusTypeID = t.RolloutStatusTypeID
		AND t.[Name] = 'ComputerDataCapture'
	LEFT OUTER JOIN Computer AS c ON c.ComputerID = r.ComputerID
	LEFT OUTER JOIN OperatingSystem o ON c.OperatingSystemID = o.OperatingSystemID
	LEFT OUTER JOIN DataCapture d ON r.SessionName = d.SessionName

GO

GO

