/*
 * $Id: site.sql 101389 2011-11-25 01:51:25Z rlowery $
 *
 * Description:
 *
 * SQL Script to build the ManageSoft site database on Microsoft SQL
 * Server.
 *
 * The steps performed by this script are:
 * 1. Create new database
 * 2. Create database table and initialiase data (skip if the table exists)
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 *
 * Copyright 2011 Flexera Software LLC
 */
USE ManageSoft
GO

-- Create Site table
IF NOT EXISTS (
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE TABLE_NAME = 'Site'
)
BEGIN
	-- Create table
	PRINT 'Creating Site table'
	CREATE TABLE Site
	(
		-- Auto-generated identity #
		SiteID INTEGER NOT NULL IDENTITY
			CONSTRAINT PK_Site PRIMARY KEY NONCLUSTERED,
			
		-- Name of site
		SiteName NVARCHAR(64) NULL DEFAULT(NULL),
			
		-- OU with full 'OU=foo, DC=....' form
		OU NVARCHAR(800) NULL DEFAULT(NULL),

		-- IP subnet
		IPSubnet VARCHAR(64) NULL DEFAULT(NULL),

		-- Description
		Description NVARCHAR(256) NULL DEFAULT(NULL),
	);
END
ELSE
	PRINT 'Using existing Site table'
GO
