/*
 * $Id: mwd-migprep.sql 97708 2010-09-16 06:38:45Z rlowery $
 *
 * Prepare to migrate a OS Deployment Manager 8.2 database into OS Deployment Manager 8.4 format.
 *
 * Use this first, then mwd-migpost.sql, and finally
 * install OS Deployment Manager 8.4 which will create the stored procedures.
 *
 * The aim here is to make minimal changes that will allow schema.sql
 * to succeed in creating any new objects, before mwd-migpost.sql finishes
 * reshaping some tables and dropping any unused objects.
 *
 * Copyright 2011 Flexera Software LLC
 */

IF NOT EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep')
	INSERT DatabaseConfiguration (Property, Value) VALUES ('WiDepMigrationStep', 0)
ELSE
BEGIN
	DECLARE @step int
	SELECT @step = Value FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep'
	PRINT 'Restarting migration from step '+STR(@step + 1, 2)
END
GO

-- Setup for mwd-migpost.sql
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 0)
BEGIN
	UPDATE DatabaseConfiguration SET Value = 1000 WHERE Property = 'WiDepMigrationStep'
END
GO

