/*
 * $Id: mwd-migprep.sql 95086 2009-11-30 06:27:00Z rlowery $
 *
 * Prepare to migrate a OS Deployment Manager 8.0 database into OS Deployment Manager 8.2 format.
 *
 * Use this first, then mwd-migpost.sql, and finally
 * install OS Deployment Manager 8.2 which will create the stored procedures.
 *
 * The aim here is to make minimal changes that will allow schema.sql
 * to succeed in creating any new objects, before mwd-migpost.sql finishes
 * reshaping some tables and dropping any unused objects.
 *
 * Copyright 2011 Flexera Software LLC
 */

IF NOT EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep')
	INSERT DatabaseConfiguration (Property, Value) VALUES ('WiDepMigrationStep', 0)
ELSE
BEGIN
	DECLARE @step int
	SELECT @step = Value FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep'
	PRINT 'Restarting migration from step '+STR(@step + 1, 2)
END
GO

-- Migrate the RolloutStatus table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 0)
BEGIN
	-- Add new columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatus'
	) AND NOT EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatus' AND COLUMN_NAME = 'SessionName'
	)
	BEGIN
		ALTER TABLE RolloutStatus
			ADD SessionName nvarchar(64) NULL
	END

	UPDATE DatabaseConfiguration SET Value = 1 WHERE Property = 'WiDepMigrationStep'
END
GO

IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 1)
BEGIN
	-- Update data into new column.
	UPDATE	RolloutStatus
	SET	SessionName = SUBSTRING(
			(
				SELECT	c.ComputerCN
				FROM	Computer AS c
				WHERE	RolloutStatus.ComputerID = c.ComputerID
			) + CONVERT(nvarchar, RolloutStatus.ComputerID),
			0,
			64
		)

	-- Trigger the constraint to be updated by dropping the existing one
	IF (Object_ID('PK_RolloutStatus') IS NOT NULL)
		ALTER TABLE RolloutStatus
			DROP CONSTRAINT PK_RolloutStatus

	-- Alter existing columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatus'
	) AND EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatus' AND COLUMN_NAME = 'ComputerID'
	)
	BEGIN
		ALTER TABLE RolloutStatus
			ALTER COLUMN ComputerID int NULL
		ALTER TABLE RolloutStatus
			ALTER COLUMN SessionName nvarchar(64) NOT NULL
	END

	UPDATE DatabaseConfiguration SET Value = 2 WHERE Property = 'WiDepMigrationStep'
END
GO

-- Migrate the RolloutStatusSummary table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 2)
BEGIN
	-- Add new columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatusSummary'
	) AND NOT EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatusSummary' AND COLUMN_NAME = 'SessionName'
	)
	BEGIN
		ALTER TABLE RolloutStatusSummary
			ADD SessionName nvarchar(64) NULL
	END

	UPDATE DatabaseConfiguration SET Value = 3 WHERE Property = 'WiDepMigrationStep'
END
GO

IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 3)
BEGIN
	-- Update data into new column.
	UPDATE	RolloutStatusSummary
	SET	SessionName = SUBSTRING(
			(
				SELECT	c.ComputerCN
				FROM	Computer AS c
				WHERE	RolloutStatusSummary.ComputerID = c.ComputerID
			) + CONVERT(nvarchar, RolloutStatusSummary.ComputerID),
			0,
			64
		)


	-- Trigger the constraint to be updated by dropping the existing one
	IF (Object_ID('PK_RolloutStatusSummary') IS NOT NULL)
		ALTER TABLE RolloutStatusSummary
			DROP CONSTRAINT PK_RolloutStatusSummary

	-- Alter existing columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatusSummary'
	) AND EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatusSummary' AND COLUMN_NAME = 'ComputerID'
	)
	BEGIN
		ALTER TABLE RolloutStatusSummary
			ALTER COLUMN ComputerID int NULL
		ALTER TABLE RolloutStatusSummary
			ALTER COLUMN SessionName nvarchar(64) NOT NULL
	END

	UPDATE DatabaseConfiguration SET Value = 4 WHERE Property = 'WiDepMigrationStep'
END
GO

-- Migrate the DataCapture table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 4)
BEGIN
	-- Add new columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'DataCapture'
	) AND NOT EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'DataCapture' AND COLUMN_NAME = 'SessionName'
	)
	BEGIN
		ALTER TABLE DataCapture
			ADD SessionName nvarchar(64) NULL
	END

	UPDATE DatabaseConfiguration SET Value = 5 WHERE Property = 'WiDepMigrationStep'
END
GO

IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 5)
BEGIN
	-- Update data into new column.
	UPDATE	DataCapture
	SET	SessionName = SUBSTRING(
			(
				SELECT	c.ComputerCN
				FROM	Computer AS c
				WHERE	DataCapture.ComputerID = c.ComputerID
			) + CONVERT(nvarchar, DataCapture.ComputerID),
			0,
			64
		)


	-- Trigger the constraint to be updated by dropping the existing one
	IF (Object_ID('PK_DataCapture') IS NOT NULL)
		ALTER TABLE DataCapture
			DROP CONSTRAINT PK_DataCapture

	-- Alter existing columns
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'DataCapture'
	) AND EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'DataCapture' AND COLUMN_NAME = 'ComputerID'
	)
	BEGIN
		ALTER TABLE DataCapture
			ALTER COLUMN ComputerID int NULL
		ALTER TABLE DataCapture
			ALTER COLUMN SessionName nvarchar(64) NOT NULL
	END

	UPDATE DatabaseConfiguration SET Value = 6 WHERE Property = 'WiDepMigrationStep'
END
GO

-- Setup for mwd-migpost.sql
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 6)
BEGIN
	UPDATE DatabaseConfiguration SET Value = 1000 WHERE Property = 'WiDepMigrationStep'
END
GO

