/*
 * $Id: mwd-migprep79.sql 101389 2011-11-25 01:51:25Z rlowery $
 *
 * Prepare to migrate a OS Deployment Manager 7.2 database into OS Deployment Manager 7.9 format.
 *
 * The aim here is to make minimal changes that will allow schema.sql
 * to succeed in creating any new objects, before mwd-migpost.sql finishes
 * reshaping some tables and dropping any unused objects.
 *
 * Copyright 2011 Flexera Software LLC
 */

IF NOT EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep')
	INSERT DatabaseConfiguration (Property, Value) VALUES ('MigrationStep', 0)
ELSE
BEGIN
	DECLARE @step int
	SELECT @step = Value FROM DatabaseConfiguration WHERE Property = 'MigrationStep'
	PRINT 'Restarting migration from step '+STR(@step + 1, 2)
END
GO

--
-- Add additional fields and constraints to the following tables
--

--
-- OSImage
--

-- Add OSImageFile column
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 0)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'OSImage'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'OSImage' AND COLUMN_NAME = 'OSImageFile'
	)
	BEGIN
		ALTER TABLE OSImage ADD OSImageFile NVARCHAR(256) NULL
	END
	UPDATE DatabaseConfiguration SET Value = 1 WHERE Property = 'MigrationStep'
END
GO

-- Add Active column
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 1)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'OSImage'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'OSImage' AND COLUMN_NAME = 'Active'
	)
	BEGIN
		ALTER TABLE OSImage ADD Active BIT NOT NULL DEFAULT 1
	END
	UPDATE DatabaseConfiguration SET Value = 2 WHERE Property = 'MigrationStep'
END
GO

-- Add ImageCommand column
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 2)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'OSImage'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'OSImage' AND COLUMN_NAME = 'ImageCommand'
	)
	BEGIN
		ALTER TABLE OSImage ADD ImageCommand NVARCHAR(256) NULL
	END
	UPDATE DatabaseConfiguration SET Value = 3 WHERE Property = 'MigrationStep'
END
GO

-- Add ImageDrive column
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 3)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'OSImage'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'OSImage' AND COLUMN_NAME = 'ImageDrive'
	)
	BEGIN
		ALTER TABLE OSImage ADD ImageDrive NVARCHAR(16) NULL
	END
	UPDATE DatabaseConfiguration SET Value = 4 WHERE Property = 'MigrationStep'
END
GO

-- Add ImageIndex column
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 4)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'OSImage'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'OSImage' AND COLUMN_NAME = 'ImageIndex'
	)
	BEGIN
		ALTER TABLE OSImage ADD ImageIndex INTEGER NULL
	END
	UPDATE DatabaseConfiguration SET Value = 5 WHERE Property = 'MigrationStep'
END
GO

-- Add RolloutStatusTypeID to RolloutStatus table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 5)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatus'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatus' AND COLUMN_NAME = 'RolloutStatusTypeID'
	)
	BEGIN
		ALTER TABLE RolloutStatus ADD RolloutStatusTypeID INTEGER DEFAULT 1
	END

	UPDATE DatabaseConfiguration SET Value = 6 WHERE Property = 'MigrationStep'
END
GO

-- Add RolloutStatusTypeID to RolloutStatusSummary table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 6)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatusSummary'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatusSummary' AND COLUMN_NAME = 'RolloutStatusTypeID'
	)
	BEGIN
		ALTER TABLE RolloutStatusSummary ADD RolloutStatusTypeID INTEGER DEFAULT 1
	END

	UPDATE DatabaseConfiguration SET Value = 7 WHERE Property = 'MigrationStep'
END
GO

-- Add Phase to RolloutStatus table
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 7)
BEGIN
	IF EXISTS (
		SELECT * FROM INFORMATION_SCHEMA.TABLES
		WHERE TABLE_NAME = 'RolloutStatus'
	) AND NOT EXISTS (
		SELECT *
		FROM INFORMATION_SCHEMA.COLUMNS
		WHERE TABLE_NAME = 'RolloutStatus' AND COLUMN_NAME = 'Phase'
	)
	BEGIN
		ALTER TABLE RolloutStatus ADD Phase NVARCHAR(256) NULL
	END

	UPDATE DatabaseConfiguration SET Value = 8 WHERE Property = 'MigrationStep'
END
GO

-- Setup for migpost.sql
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'MigrationStep' AND VALUE = 8)
BEGIN
	UPDATE DatabaseConfiguration SET Value = 1000 WHERE Property = 'MigrationStep'
END
GO

