/*
 * $Id: mwd-migpost.sql 95086 2009-11-30 06:27:00Z rlowery $
 *
 * Finish migrating a OS Deployment Manager 8.0 database into OS Deployment Manager 8.2 format.
 *
 * Use mwd-migprep.sql first, then this, and finally
 * install OS Deployment Manager 8.2 which will create the stored procedures.
 *
 * Copyright 2011 Flexera Software LLC
 */

USE ManageSoft
GO

/*
 * Check that we are upgrading from a 8.0 database...
 */
DECLARE @schema_version char(10)
SET @schema_version = (SELECT Value FROM DatabaseConfiguration
		WHERE Property = 'WiDepSchemaVersion')

IF (@schema_version = '8.0')
BEGIN
	PRINT 'Completing migration to OS Deployment Manager 8.2 database schema...'
END
ELSE IF (@schema_version = '8.2')
BEGIN
	RAISERROR ('Your OS Deployment Manager database has already been migrated to the 8.2 schema.', 16, 1)
	RAISERROR ('For more information on migrating your database, refer to the OS Deployment Guide.', 16, 1)
END
ELSE
BEGIN
	RAISERROR ('This script can only migrate from the OS Deployment Manager database schema version 8.0.', 16, 1)
	RAISERROR ('Please migrate your database schema to version 8.0 before executing this script again.', 16, 1)
	RAISERROR ('For more information on migrating your database, refer to the OS Deployment Guide.', 16, 1)
END
GO

--===========================================================================
--		Update the DatabaseConfiguration table
--
--		NOTE: do this last
--===========================================================================
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 1000)
BEGIN
	PRINT 'Recording successful migration'
	UPDATE DatabaseConfiguration SET Value = '8.2'
		WHERE Property = 'WiDepSchemaVersion'
	DELETE DatabaseConfiguration WHERE Property = 'WiDepMigrationStep'
END
GO
