/*
 * $Id: mwd-migpost.sql 89780 2008-10-13 06:41:33Z pca $
 *
 * Finish migrating a OS Deployment Manager 7.9 database into OS Deployment Manager 8.0 format.
 *
 * Copyright 2011 Flexera Software LLC
 */

USE ManageSoft
GO

/*
 * Check that we are upgrading from a 7.9 database...
 */
DECLARE @schema_version char(10)
SET @schema_version = (SELECT Value FROM DatabaseConfiguration
		WHERE Property = 'WiDepSchemaVersion')

IF (@schema_version = '7.9')
BEGIN
	PRINT 'Completing migration to OS Deployment Manager 8.0 database schema...'
END
ELSE IF (@schema_version = '8.0')
BEGIN
	RAISERROR ('Your OS Deployment Manager database has already been migrated to the 8.0 schema.', 16, 1)
	RAISERROR ('For more information on migrating your database, refer to the OS Deployment Guide.', 16, 1)
END
ELSE
BEGIN
	RAISERROR ('This script can only migrate from the OS Deployment Manager database schema version 7.9.', 16, 1)
	RAISERROR ('Please migrate your database schema to version 7.9 before executing this script again.', 16, 1)
	RAISERROR ('For more information on migrating your database, refer to the OS Deployment Guide.', 16, 1)
END
GO

--===========================================================================
--		Update the DatabaseConfiguration table
--
--		NOTE: do this last
--===========================================================================
IF EXISTS(SELECT * FROM DatabaseConfiguration WHERE Property = 'WiDepMigrationStep' AND VALUE = 1000)
BEGIN
	PRINT 'Recording successful migration'
	UPDATE DatabaseConfiguration SET Value = '8.0'
		WHERE Property = 'WiDepSchemaVersion'
	DELETE DatabaseConfiguration WHERE Property = 'WiDepMigrationStep'
END
GO
