/* AUTOMATICALLY GENERATED on Fri Dec 16 10:11:26 AUSEDT 2011
 * for ManageSoft release 8.6 (build 8.1978)
 *
 * DO NOT EDIT THIS FILE BY HAND!
 * 
 * Protected by US patents 6,006,034 and 6,360,366.
 * Copyright 2011 ManageSoft Corporation. All rights reserved.
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

USE ManageSoft
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: RolloutGroupParentName
 * - returns full name of group
 *
 *	Input:
 *	- @inGroupID
 *	- @outFullName (output parameter)
 *
 *	Returns:
 *	- none
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'RolloutGroupParentName' AND xtype = 'P'
)
        DROP PROCEDURE RolloutGroupParentName
GO

CREATE PROCEDURE RolloutGroupParentName
	@inGroupID INT,  -- Pass in GroupID
	@outFullName NVARCHAR(800) OUTPUT
AS
BEGIN

DECLARE @fullName as NVARCHAR (800)
DECLARE @grpName as NVARCHAR(64)
DECLARE @tmpName as NVARCHAR(64)
DECLARE @parentID as INT

DECLARE grp_cur CURSOR FOR
	SELECT GroupName, ParentID 
	FROM RolloutGroup
	WHERE GroupID = @inGroupID

OPEN grp_cur
FETCH NEXT FROM grp_cur INTO @tmpName, @parentID

CLOSE grp_cur
DEALLOCATE grp_cur	

SET @fullName  = ''
SET @grpName  = @tmpName

--Check parent is not root or server and exists	
WHILE @parentID <> 0 AND EXISTS(SELECT * FROM RolloutGroup WHERE GroupID=@parentID)
BEGIN
	DECLARE grpParent_cur CURSOR FOR 
		SELECT GroupName , ParentID  
		FROM RolloutGroup
		WHERE GroupID = @parentID		

	OPEN grpParent_cur
	FETCH NEXT from grpParent_cur into @tmpName, @parentID		
				
	CLOSE grpParent_cur
	DEALLOCATE grpParent_cur
	
	--Check parent is not root or server and exists	
	IF @parentID <> 0 AND EXISTS(SELECT * FROM RolloutGroup WHERE GroupID=@parentID)
	BEGIN	
		IF @fullname <> ''
			SET @fullname = @tmpName + '->' + @fullname
		ELSE
			SET @fullname = @tmpName 			
	END
	ELSE
	BEGIN
		IF @fullname <> ''
			SET @fullname = @tmpName + '->' + @fullname
		ELSE
			SET @fullname = @tmpName 
		BREAK
	END
END 	

IF @fullname <> ''
	SET  @outFullName = @grpName + ' (' + @fullName + ')'
ELSE
	SET  @outFullName = @grpName

RETURN 0 

END

GO

CopyPermission 'RolloutGroupParentName', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: ListRolloutGroups
 * - returns full name of group
 *
 *	Input:
 *	- @rolloutgrp
 *	- @oudn 
 *	- @ouMatch
 *
 *	Returns:	
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'ListRolloutGroups' AND xtype = 'P'
)
        DROP PROCEDURE ListRolloutGroups
GO

CREATE PROCEDURE ListRolloutGroups
	@rolloutgrp NVARCHAR(800)= N'%',	--Default: For all Groups
	@oudn VARCHAR(800) = '%',	--Default: For all OUs
	@ouMatch BIT=1			--Include sub-OUs? Default: 1
AS

	-- Retrieve Summary Data for ALL GROUPs
	CREATE TABLE #parentListTbl
	(	
		GroupID INT,
		GroupFullName NVARCHAR(800) COLLATE database_default
	)
	
	DECLARE grpList_cursor CURSOR FOR
		SELECT GroupID, ParentID FROM RolloutGroup
	
	DECLARE @grpID INT
	DECLARE @fullName NVARCHAR(800)
	DECLARE @parentID INT
	
	OPEN grpList_cursor
	FETCH NEXT FROM grpList_cursor INTO @grpID, @parentID
	WHILE @@FETCH_STATUS =0
	BEGIN
		--Retrieve parent name
		EXECUTE RolloutGroupParentName @grpID, @outFullName = @fullName OUTPUT 			
		INSERT INTO #parentListTbl VALUES ( @grpID, @fullName ) 	
		SET @fullName = NULL -- reset		
		FETCH NEXT FROM grpList_cursor INTO @grpID, @parentID
	END
	
	CLOSE grpList_cursor
	DEALLOCATE grpList_cursor
	
	CREATE TABLE #Organization(OUID int PRIMARY KEY)
	EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

	SELECT DISTINCT			
		grp.GroupID,
		parent.GroupFullName

	FROM	
		#parentListTbl AS parent, 
		RolloutGroup AS grp, 
		RolloutGroupMember AS mem,
		Computer AS c,
		#Organization AS s
	WHERE	
		parent.GroupID = grp.GroupID
		AND grp.GroupName LIKE @rolloutgrp 
		AND grp.GroupID = mem.GroupID
		AND mem.MemberID = c.ComputerID
		AND c.ComputerOUID = s.OUID

	DROP TABLE #parentListTbl
	
GO

CopyPermission 'ListRolloutGroups', 'mgsOSBreakdown'
GO
/* 
 * $Id: NetworkDevicesDiscoverySummary.sql 101389 2011-11-25 01:51:25Z rlowery $
 * $Locker$
 *
 * DESCRIPTION: Stored Procedure: NetworkDevicesDiscoverySummary
 *	Input:
 * 	- @oudn: selected OU Name. - All OUs/ Specific OU  
 *	- @ouMatch: match on child OUs as well
 *	- @subnet: match on IP Subnet. Default = all subnets
 *
 *	Returns:
 *	- Total Count for Computer, Total
 *	- Count for Computers with Inventories, Inventory 
 *  - NOTE: Count for Computers without Inventories, NonInventory = Total - Inventory
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 *
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NetworkDevicesDiscoverySummary' AND xtype = 'P'
)
        DROP PROCEDURE NetworkDevicesDiscoverySummary
GO


CREATE PROCEDURE NetworkDevicesDiscoverySummary
	@oudn VARCHAR(800)='%',
	@ouMatch BIT=1, --Values:[0=do exact OU Match | 1=include child-OUs in match]
	@subnet VARCHAR(128)='%'  --subnet (size=64*2 --to take into acct encoded chars)
AS
BEGIN

/*
 * COMMENT: This is required so that subnets with NULL values are picked up
 * when @subnet='%'; but not pick the NULL subnet when @subnet <> '%'
 */

--Boolean whether to do subnet match or not
DECLARE @allSubnetMatch BIT
IF @subnet = '%'
	SET @allSubnetMatch = 0 --FALSE
ELSE
	SET @allSubnetMatch = 1 --TRUE
	
CREATE TABLE #Organization(OUID int PRIMARY KEY)
EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

	SELECT  				
		COUNT(N.DeviceID) as Total,
		COUNT(DISTINCT I.ComputerID) as Inventory --Any Inventory HW or SW
		--NonInventory = Total - Inventory	(done by data manager)	
	
	FROM 
	NetworkDevice as N 
		LEFT OUTER JOIN 
		(
			Computer as C 
				LEFT OUTER JOIN InventoryReport as I
				ON (C.ComputerID = I.ComputerID AND I.UserID = 1)
		) 
		ON N.ComputerID  = C.ComputerID 
		INNER JOIN #Organization AS S
		ON S.OUID = C.ComputerOUID
		
	WHERE N.DuplicateID IS NULL 
		AND N.DeviceRole IN (0, 1, 2)
		AND 
		( 
			@allSubnetMatch = 0 --if expression is false, then do subnet match
			OR N.IPSubnet LIKE @subnet
		)
END
GO

CopyPermission 'NetworkDevicesDiscoverySummary', 'mgsOSBreakdown'
GO
/* 
 * $Id: NetworkDevicesDiscoverySummaryList.sql 101389 2011-11-25 01:51:25Z rlowery $
 * $Locker$
 *
 * DESCRIPTION: Stored Procedure: NetworkDevicesDiscoverySummaryList
 *	Input:
 * 	- @oudn: selected OU Name. - All OUs/ Specific OU  
 *	- @ouMatch: match on child OUs as well
 *	- @subnet: match on IP Subnet. Default = all subnets
 *
 *	Returns:
 *	- OU, 
 *	- Discovery columns like DeviceName, IPAddress, PhysicalAddress, ...,
 *	- LastSoftwareReportDate, LastHardwareReportDate

 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 *
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NetworkDevicesDiscoverySummaryList' AND xtype = 'P'
)
        DROP PROCEDURE NetworkDevicesDiscoverySummaryList
GO


CREATE PROCEDURE NetworkDevicesDiscoverySummaryList
	@oudn VARCHAR(800)='%',
	@ouMatch BIT=1, --Values:[0=do exact OU Match | 1=include child-OUs in match]
	@subnet VARCHAR(128)='%'  --subnet (size=64*2 --to take into acct encoded chars)
AS
BEGIN

/*
 * COMMENT: This is required so that subnets with NULL values are picked up
 * when @subnet='%'; but not pick the NULL subnet when @subnet <> '%'
 */

--Boolean whether to do subnet match or not
DECLARE @allSubnetMatch BIT
IF @subnet = '%'
	SET @allSubnetMatch = 0 --FALSE
ELSE
	SET @allSubnetMatch = 1 --TRUE
	
CREATE TABLE #Organization(OUID int PRIMARY KEY)
EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

	SELECT
		dbo.OUName(S.OUID) AS OU,
		C.ComputerID, C.ComputerCN,
		N.DeviceName, N.DNSFullName, N.NTDomainName,
		N.IPAddress, N.IPSubnet, N.IPSubnetMask,
		N.PhysicalAddress,
		DeviceRole =
			CASE N.DeviceRole				
				WHEN 0 THEN 'Computer'
				WHEN 1 THEN 'Workstation'
				WHEN 2 THEN 'Server'
				WHEN 3 THEN 'Printer'
				WHEN 4 THEN 'Switch'
				WHEN 5 THEN 'Router'
				WHEN 6 THEN 'Hub'
				ELSE '' -- Unknown; includes NULL
			END,  
		N.OperatingSystem,
		IsManaged = 
			CASE N.IsManaged
				WHEN 0 THEN 'no'
				WHEN 1 THEN 'yes'
				ELSE '' -- Unknown; includes NULL
			END,
		N.[Description], N.SystemDescription, N.SystemLocation,
		N.SystemContact, N.FirstDiscovered, N.LastUpdate,
		N.LastDataSourceType, I.SWDate, I.HWDate
	FROM NetworkDevice AS N
	LEFT OUTER JOIN 
	(
		Computer as C 
			LEFT OUTER JOIN InventoryReport as I
			ON (C.ComputerID = I.ComputerID AND I.UserID = 1)
	) 
	ON N.ComputerID = C.ComputerID 
	INNER JOIN #Organization as S
	ON S.OUID = C.ComputerOUID	
		
	WHERE N.DuplicateID IS NULL 
	  AND ( 
		--if expression is false, do subnet match
		@allSubnetMatch = 0 OR N.IPSubnet LIKE @subnet
	  )	
END
GO


CopyPermission 'NetworkDevicesDiscoverySummaryList', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION:
 *
 *	This file contains all the related Hardware Assessment stored procedures.
 * 	- WiMiHardwareAssessmentCreateViewsOnRules
 * 	- WiMiDeleteOldRulesFromCacheNView
 * 	- WiMiUpdateHardwareAssessmentViews
 * 	- WiMiPopulateHardwareAssessmentCache
 * 	- WiMiGetComputerSetFromComputerNInventoryReportTbl
 * 	- WiMiGetComputerAssessmentForComputerSet
 * 	- WiMiValidateNUpdateAssessmentCache
 *	
 *	NOTE: Procedures should be added in the order specified 
 *	as they are dependent on other procedures existing in database. 
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

------------------------------------------------------------------
--STORED PROCEDURE: WiMiHardwareAssessmentCreateViewsOnRules
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiHardwareAssessmentCreateViewsOnRules:  
 *	Creates views corresponding to Assessment Rules (all or
 *	only new / modified ones).
 *
 *	IMPORTANT NOTE: Only call this procedure with default	@oudn /
 *	@ouMatch filter as currently they are not stored anywhere.
 *	
 *	Input:
 *		@oudn, @ouMatch
 *		@getModifiedRulesOnly
 *
 *	Output:
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiHardwareAssessmentCreateViewsOnRules' AND xtype = 'P'
)
        DROP PROCEDURE WiMiHardwareAssessmentCreateViewsOnRules
GO

/*
 * COMMENT: in future, add parameter for AssessmentRuleSet
 * so as to do processing only for given AssessmentRuleSet
 */
CREATE PROCEDURE WiMiHardwareAssessmentCreateViewsOnRules
	@getModifiedRulesOnly BIT=0  --Modified Rules [0:false|1:true].
AS
BEGIN

--------------------------------------------------------------------------
--Variables set from CURSOR that reads from HardwareAssessmentRule table
--------------------------------------------------------------------------
DECLARE @viewname varchar(64)
DECLARE @ruleId int 
DECLARE @severityFailId int -- Fail
DECLARE @class varchar(256) 
DECLARE @property varchar(64) 
DECLARE @compexpr varchar(1024) 
DECLARE @sqltype varchar(20)
DECLARE @aggr varchar(10) 
DECLARE @msgFail varchar(256)
DECLARE @msgUnk varchar(256)
DECLARE @msgOk varchar(256)

-- LHS value of Comparision Expression
DECLARE @lhsexpr varchar(350) SET @lhsexpr = ''
-- Property Value used in Comparision Expression evaluation
DECLARE @value varchar(400) SET @value = ''
-- Group By Clause
DECLARE @grpbyClause varchar(200) set @grpbyClause = ''

DECLARE @severityUnkId int -- Unknown
SELECT @severityUnkId = AssessmentSeverityID 
	from HardwareAssessmentSeverity 
	where AssessmentSeverityMessage LIKE 'Not Inventoried'

DECLARE @severityOkId int -- Pass
SELECT @severityOkId = AssessmentSeverityID 
	from HardwareAssessmentSeverity 
	where AssessmentSeverityMessage LIKE 'Meets requirements'


BEGIN TRANSACTION

-----------------------------------------------------------------
--Cursor contains AssessmentRuleIDs only for modified/new rules 
--for which a new view has to be created.
--Note: Views for disabled rules are also created.
-----------------------------------------------------------------
DECLARE rules_cursor CURSOR FOR
	SELECT DISTINCT
		r.AssessmentRuleID, r.AssessmentSeverityID, r.Class, r.Property,
		r.ComparisonExpr, r.SQLType, r.AggregateFn, r.FailMessage, r.NotknownMessage, r.PassMessage		
	FROM HardwareAssessmentRule r 
		LEFT OUTER JOIN HardwareAssessmentCache w
		ON r.AssessmentRuleID = w.AssessmentRuleID 
	WHERE 
	(	
		@getModifiedRulesOnly = 0  -- if true, then get all Rules		
		OR w.AssessmentRuleID IS NULL -- new rules
		OR DATEDIFF(second, w.CacheEvaluatedDate, r.RuleModifiedDate) > 0 --modified rules
	) -- filter on new/ modified rules 

OPEN rules_cursor
FETCH NEXT FROM rules_cursor
	INTO	@ruleId, @severityFailId, @class, @property, 
		@compexpr, @sqltype, @aggr, @msgFail, @msgUnk, @msgOk
WHILE @@FETCH_STATUS = 0
BEGIN

	--------------------------------------------------------------------------
	--Creates a View for each rule for all Computers in a given OUDN/ OUMatch
	--------------------------------------------------------------------------
	SET @viewname = 'HardwareAssessmentView_onRule' + CAST(@ruleId AS VARCHAR(4))

	IF @sqltype IS NULL
	begin
		-- type of HardwareValue.Value
		SET @sqltype = 'VARCHAR(256)'
	end
	
	/* 
	 * NOTE: 
	 * We apply MAX when there is no aggregation applied to HardwareValue.Value.
	 * Therefore, we pick up only one record for a given Hardware Property irrespective
	 * whether its a string or number and then apply comparison expression on this value
	 * to determine Assessment Severity.
	 */
	 
	IF @aggr IS NULL
	begin
		-- type of Aggregate Function (default)
		SET @aggr = 'MAX' 
	end

	--LHS value of Comparision Expression	
	SET @lhsExpr = 'hv.Value' 
	-- Property Value used in Comparision Expression evaluation
	SET @value = 'hv.Value'

	IF @sqltype IS NOT NULL -- cast to SQLType
	begin
		SET @lhsExpr = 'CAST(' + @lhsExpr + ' AS ' + @sqltype + ')'	
	end
	IF @aggr IS NOT NULL -- apply Aggregate Function
	begin
		SET @lhsExpr = @aggr + '(' + @lhsExpr + ')'	
		SET @value = 'CAST(' + @lhsExpr + 'AS VARCHAR(256))'
	end

	-- Group By Clause 
	IF @aggr IS NOT NULL		
		SET @grpbyClause = 'GROUP BY c.ComputerID, c.ComputerOUID, ir.HWDate, hc.Class, hp.Property'

	-- escape ' as its used within dynamic SQL
	DECLARE @eMsgOk varchar(512)
	SET @eMsgOk = REPLACE(@msgOk, '''', '''''' )
	DECLARE @eMsgFail VARCHAR(512)
	SET @eMsgFail = REPLACE(@msgFail, '''', '''''' )
	DECLARE @eMsgUnk VARCHAR(512)
	SET @eMsgUnk = REPLACE(@msgUnk, '''', '''''' )
	
	-- Convert data type INT into VARCHAR when constructing SQL query
	-- NOTE: Required for SQL 7.0 (it complains at runtime)
	DECLARE @severityUnkId_var varchar(4)
	SET @severityUnkId_var = CAST(@severityUnkId as varchar(4))
	DECLARE @severityFailId_var varchar(4)
	SET @severityFailId_var = CAST(@severityFailId as varchar(4))
	DECLARE @severityOkId_var varchar(4)
	SET @severityOkId_var = CAST(@severityOkId as varchar(4))
	DECLARE @ruleId_var varchar(5)
	SET @ruleId_var = CAST(@ruleId as varchar(5))

	--------------------------------------------------------------------------
	--Create a View per Hardware Assessment Rule
	--------------------------------------------------------------------------
	
	IF EXISTS (
		SELECT * FROM dbo.sysobjects
		WHERE [name] = @viewname AND xtype = 'V'
	)
		EXEC('DROP VIEW [' + @viewname + ']')

	EXEC('
	CREATE VIEW ' + @viewname + ' 
	AS
	SELECT 
	c.ComputerID,
	c.ComputerOUID,
	ir.HWDate AS LastHardwareReportDate, 
	CASE
		WHEN ' + @lhsExpr + ' IS NULL THEN ' + @severityUnkId_var + ' 
		WHEN ' + @lhsExpr + ' ' + @compexpr + ' THEN ' + @severityFailId_var + ' 
		ELSE ' + @severityOkId_var + '
	END AS AssessmentSeverityId,
	CASE
		WHEN ' + @lhsExpr + ' IS NULL THEN ''' + @eMsgUnk + '''
		WHEN ' + @lhsExpr + ' ' + @compexpr + ' THEN ''' + @eMsgFail + ''' 	
		ELSE ''' + @eMsgOk + '''
	END AS AssessmentMessage,
	' + @ruleId_var + ' as AssessmentRuleId,
	hc.Class AS Class,
	hp.Property AS Property, 
	' + @value + ' as PropertyValue 
	FROM	Computer AS c
		LEFT OUTER JOIN InventoryReport AS ir
		ON (ir.ComputerID = c.ComputerID AND ir.UserID = 1)
		LEFT OUTER JOIN HardwareObject AS ho
			INNER JOIN HardwareClass AS hc
			ON (hc.HardwareClassID = ho.HardwareClassID AND hc.Class = ''' + @class + ''')
			INNER JOIN HardwareValue AS hv
			ON (hv.HardwareObjectID = ho.HardwareObjectID)
			INNER JOIN HardwareProperty AS hp
			ON (hp.HardwarePropertyID = hv.HardwarePropertyID AND hp.Property = ''' + @property + ''')
		ON ho.ComputerID = c.ComputerID
	' + @grpbyClause
	)
	
	EXEC CopyPermission @viewname, 'HardwareAssessmentRule'
	
	--Reset the Group By Clause 
	SET @grpbyClause = ''

	---------------------------------------------------------------------------
	FETCH NEXT FROM rules_cursor
		INTO	@ruleId, @severityFailId, @class, @property, 
			@compexpr, @sqltype, @aggr, @msgFail, @msgUnk, @msgOk
END

CLOSE rules_cursor
DEALLOCATE rules_cursor

COMMIT TRANSACTION

END
GO

EXEC CopyPermission 'WiMiHardwareAssessmentCreateViewsOnRules', 'mgsOSBreakdown'
GO

------------------------------------------------------------------
--STORED PROCEDURE: WiMiDeleteOldRulesFromCacheNView
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiDeleteOldRulesFromCacheNView:  
 *	Deletes records from Cache table and Drops views corresponding 
 *	to deleted Assessment Rules
 *	
 *
 *	Input:
 *		@delCacheTbl, @delViews
 *
 *	Output:
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiDeleteOldRulesFromCacheNView' AND xtype = 'P'
)
        DROP PROCEDURE WiMiDeleteOldRulesFromCacheNView
GO
 
CREATE PROCEDURE WiMiDeleteOldRulesFromCacheNView
	@delCacheTbl BIT=1, -- Delete from Cache table {false:0| true:1}  
	@delViews BIT=1 -- Drop views {false:0| true:1}
AS
BEGIN

--------------------------------------------------------------
--Update Cache table by deleting rules that are disabled
--------------------------------------------------------------
DELETE HardwareAssessmentCache 
	FROM HardwareAssessmentCache w, HardwareAssessmentRule r
	WHERE w.AssessmentRuleID = r.AssessmentRuleID
		AND r.Enabled = 0

--------------------------------------------------------------
--Update Cache table by deleting rules that no longer exist
--------------------------------------------------------------
IF (@delCacheTbl = 1)
BEGIN
	DELETE HardwareAssessmentCache 
	FROM HardwareAssessmentCache w
	WHERE w.AssessmentRuleID NOT IN (
			SELECT AssessmentRuleID 
			FROM HardwareAssessmentRule 
	)
END  -- end of IF loop

--------------------------------------------------------------
--Update by Views corresponding to rules that no longer exist
--------------------------------------------------------------
IF (@delViews = 1)
BEGIN
	--Read from System table the name of views
	--SELECT * FROM dbo.sysobjects
	--WHERE [name] LIKE 'HardwareAssessmentView_onRule%' AND xtype = 'V'
	
	CREATE TABLE #ViewName ( ViewName VARCHAR(64) COLLATE database_default )

	DECLARE @viewName VARCHAR(64)
	DECLARE rulesID_cursor CURSOR FOR
		SELECT AssessmentRuleID FROM HardwareAssessmentRule

	OPEN rulesID_cursor
	DECLARE @rulesID  INT
	FETCH NEXT FROM rulesID_cursor INTO @rulesID
	WHILE @@FETCH_STATUS = 0
	BEGIN		
		SET @viewName = 'HardwareAssessmentView_onRule' + CAST(@rulesID as Varchar(4))		
		INSERT INTO #ViewName VALUES (@viewName)		
		FETCH NEXT FROM rulesID_cursor INTO @rulesID
	END
	CLOSE rulesID_cursor
	DEALLOCATE rulesID_cursor

	DECLARE oldrules_cursor CURSOR FOR
		SELECT  [name]
		FROM dbo.sysobjects 
			WHERE [name] LIKE 'HardwareAssessmentView_onRule%' 
			AND xtype = 'V' 	
			AND [name] NOT IN ( Select viewname from #ViewName )

	OPEN oldrules_cursor
	FETCH NEXT FROM oldrules_cursor INTO @viewname
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF EXISTS (
			SELECT * FROM dbo.sysobjects
			WHERE [name] = @viewname AND xtype = 'V'
		)
			EXEC ('DROP VIEW ' +  @viewname )	

		FETCH NEXT FROM oldrules_cursor INTO @viewname
	END
	CLOSE oldrules_cursor
	DEALLOCATE oldrules_cursor
	
	DROP TABLE #ViewName

END -- end of IF loop

END 
GO

EXEC CopyPermission 'WiMiDeleteOldRulesFromCacheNView', 'mgsOSBreakdown'
GO


------------------------------------------------------------------
--STORED PROCEDURE: WiMiUpdateHardwareAssessmentViews
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiUpdateHardwareAssessmentViews:  
 *	Updates Hardware Assessment Views by deleting out dated ones
 *	and creating views for new and modified Assessment Rules.
 *	
 *	Input:
 *		@getModifiedRulesOnly
 *
 *	Output:
 *
 *	Usage:
 *	EXEC 	WiMiUpdateHardwareAssessmentViews 1
 *
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiUpdateHardwareAssessmentViews' AND xtype = 'P'
)
        DROP PROCEDURE WiMiUpdateHardwareAssessmentViews
GO

/*
 * COMMENT: in future, add parameter for AssessmentRuleSet
 * so as to do processing only for given AssessmentRuleSet
 */
 
CREATE PROCEDURE WiMiUpdateHardwareAssessmentViews
	@getModifiedRulesOnly BIT=0 --Create views for New/Modified rules only. Default: all rules.
AS
BEGIN

BEGIN TRANSACTION
	--Drop Views for deleted Assessment Rules
	EXEC WiMiDeleteOldRulesFromCacheNView @delCacheTbl=0 , @delViews=1 
COMMIT TRANSACTION

BEGIN TRANSACTION
	--Create views for new/modified Assessment Rules
	--Note: Currently, we create view on ALL OUs.	
	EXECUTE WiMiHardwareAssessmentCreateViewsOnRules 
		@getModifiedRulesOnly --Get new/modified Rules
COMMIT TRANSACTION

END
GO

EXEC CopyPermission 'WiMiUpdateHardwareAssessmentViews', 'mgsOSBreakdown'
GO


------------------------------------------------------------------
--STORED PROCEDURE: WiMiPopulateHardwareAssessmentCache
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiPopulateHardwareAssessmentCache:  
 *	Populates Cache table. Optionally, creates views for all or only
 *	new and modified Assessment Rules.
 *	
 *	Input:
 *		@oudn, @ouMatch
 *		@recreateViews, @getModifiedRulesOnly
 *
 *	Output:
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiPopulateHardwareAssessmentCache' AND xtype = 'P'
)
        DROP PROCEDURE WiMiPopulateHardwareAssessmentCache
GO

/*
 * COMMENT: in future, add parameter for AssessmentRuleSet
 * so as to do processing only for given AssessmentRuleSet
 */

CREATE PROCEDURE WiMiPopulateHardwareAssessmentCache
	@recreateView BIT=0, -- Re-create views = {0:False | 1:True}. Default: false 
	@getModifiedRulesOnly BIT=0 --New/Modified rules. Default: all rules; no new/modified.
AS
BEGIN

-----------------------------------------------------------------
--Create a new view(s) based on lastest rules.
--Optionally, only modified/new rule's corresponding view is re-created
-----------------------------------------------------------------

/*
 * REVISIT: User does not have rights to Create and Drop Views.
 * Currently, this updated separately.
 *
 * IF (@recreateView = 1)
 * BEGIN
 *	--Currently, we create view on ALL OUs.	
 *	EXECUTE WiMiHardwareAssessmentCreateViewsOnRules 
 *		'%', --Do all OUs
 *		1, --Include child OUs
 *		@getModifiedRulesOnly --Get new/modified Rules
 * END
 *
 */

--else... use the existing Views

-----------------------------------------------------------------
--Populate with fresh set of recordsets
-----------------------------------------------------------------
BEGIN TRANSACTION

DECLARE @viewName Varchar(64)
--Insert/Update SQL string contains name of view
DECLARE @SQLstmt nvarchar(4000)

DECLARE rulesID_cursor CURSOR FOR
	SELECT DISTINCT r.AssessmentRuleID --, w.AssessmentRuleID
	FROM HardwareAssessmentRule r 
		LEFT OUTER JOIN HardwareAssessmentCache w
		ON r.AssessmentRuleID = w.AssessmentRuleID 
	WHERE  
	(	
		@getModifiedRulesOnly = 0  -- if true, then get all Rules		
		OR w.AssessmentRuleID IS NULL -- new rules
		OR DATEDIFF(second, w.CacheEvaluatedDate, r.RuleModifiedDate) > 0 --modified rules
	) -- filter on new/ modified rules
	AND r.Enabled = 1 -- filter on Enabled rules

OPEN rulesID_cursor

DECLARE @rulesID  int
FETCH NEXT FROM rulesID_cursor INTO	@rulesID
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @viewName = 'HardwareAssessmentView_onRule' + CAST(@rulesID as Varchar(4))
	
	----------------------------------------------------------
	-- Set Assessment Rule exists in Cache Flag for given OUDN
	-- AND Determine OU condition
	----------------------------------------------------------	
	DECLARE @ruleExists BIT SET @ruleExists = 0 --initialise

		--Check if Assessment Rule exists in cache for given OUDN		
		SELECT @ruleExists = 
			CASE 
				WHEN w.AssessmentRuleID IS NOT NULL THEN 1
			END
			FROM 
				Computer c, 
				#Organization s,
				HardwareAssessmentCache w
			WHERE
				c.ComputerOUID = s.OUID --driven by Computer table for correctness
				AND c.ComputerID = w.ComputerID 
				AND AssessmentRuleID = @rulesID

	----------------------------------------------------------
	--Update existing records when Rule exists (though may be modified)
	----------------------------------------------------------
	IF (@ruleExists = 1)
	BEGIN
		SET @SQLstmt = 
			N'UPDATE HardwareAssessmentCache
			SET 		
				ComputerOUID = tmp.ComputerOUID,
				LastHardwareReportDate = tmp.LastHardwareReportDate,
				AssessmentSeverityID = tmp.AssessmentSeverityID,
				CacheEvaluatedDate = GetDate()
			FROM
			(
				SELECT 
					v.ComputerID, 
					v.ComputerOUID,
					v.LastHardwareReportDate,
					v.AssessmentRuleID,
					v.AssessmentSeverityID
				FROM ' + @viewName  + ' v, #Organization s
				WHERE v.ComputerOUID = s.OUID 
			) AS tmp, HardwareAssessmentCache AS w	
			WHERE w.ComputerID = tmp.ComputerID
			AND w.AssessmentRuleID = tmp.AssessmentRuleID'
	END

	----------------------------------------------------------
	--Insert records either when Rule does not exist OR when
	--Views and Rules are up to date but data in Cache table is
	--out of date for given @oudn/@ouMatch values.
	----------------------------------------------------------
	
	DECLARE @cacheOutOfDate BIT
	--When Views are up to date and require to update cache for all Rules
	IF (@recreateView = 0 AND @getModifiedRulesOnly = 0)
		SET @cacheOutOfDate = 1 -- true
	ELSE
		SET @cacheOutOfDate = 0 -- false		

	--IF (@ruleExists = 0) OR (@recreateView = 0 AND @getModifiedRulesOnly = 0)	
	IF (@ruleExists = 0) OR (@cacheOutOfDate = 1)
	BEGIN	
		SET @SQLstmt = 
			N'INSERT INTO HardwareAssessmentCache
			(
				ComputerID, 
				ComputerOUID, 
				LastHardwareReportDate, 
				AssessmentRuleID,
				AssessmentSeverityID, 
				CacheEvaluatedDate
			)
			SELECT 
				v.ComputerID, 
				v.ComputerOUID,
				v.LastHardwareReportDate,
				v.AssessmentRuleID,
				v.AssessmentSeverityID,
				GetDate() as CacheEvalutedDate 
			FROM ' + @viewName  + ' v, #Organization s
			WHERE v.ComputerOUID = s.OUID'
	END

	EXEC sp_executesql @SQLstmt

	FETCH NEXT FROM rulesID_cursor INTO	@rulesID
END
CLOSE rulesID_cursor
DEALLOCATE rulesID_cursor

COMMIT TRANSACTION

END
GO

EXEC CopyPermission 'WiMiPopulateHardwareAssessmentCache', 'mgsOSBreakdown'
GO


------------------------------------------------------------------
--STORED PROCEDURE: WiMiGetComputerSetFromComputerNInventoryReportTbl
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiGetComputerSetFromComputerNInventoryReportTbl:  
 *	Gets set of computers that have been added to Computer table
 *	and those with new inventory since cache was last evaluated.
 *	
 *	Input:
 *		@oudn, @ouMatch		
 *
 *	Output:
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiGetComputerSetFromComputerNInventoryReportTbl' AND xtype = 'P'
)
        DROP PROCEDURE WiMiGetComputerSetFromComputerNInventoryReportTbl
GO

CREATE PROCEDURE WiMiGetComputerSetFromComputerNInventoryReportTbl
AS
BEGIN
	--Add recordsets for new ComputerIDs or new Inventories
	INSERT INTO #ComputerSet
	SELECT DISTINCT
	c.ComputerID,
	ExistingComputer =
		CASE
			WHEN w.ComputerID IS NULL THEN 0 -- Add new computer
			ELSE 1 --Update existing Computer
		END 
	FROM 
	#Organization s INNER JOIN Computer c 
	ON s.OUID = c.ComputerOUID 
		LEFT OUTER JOIN InventoryReport ir
		ON 
		(
			c.ComputerID = ir.ComputerID 
			AND ir.UserID = 1 --HW Inventory only
		)
			LEFT OUTER JOIN HardwareAssessmentCache w	
			ON
			(
				c.ComputerOUID = w.ComputerOUID 
				AND c.ComputerID = w.ComputerID 
			)
	WHERE 
		(
			w.ComputerID IS NULL 
			OR ir.ComputerID IS NULL
			OR DATEDIFF(second, w.CacheEvaluatedDate, ir.HWDate ) > 0
		) --record not in Cache or Inventory or new HW Inventory
END -- end of BEGIN loop
GO

EXEC CopyPermission 'WiMiGetComputerSetFromComputerNInventoryReportTbl', 'mgsOSBreakdown'
GO

------------------------------------------------------------------
--STORED PROCEDURE: WiMiGetComputerAssessmentForComputerSet
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiGetComputerAssessmentForComputerSet:  
 *	Gets assessment against each Assessment Rule for a given set of computers. 
 *	
 *	Input:
 *		@tblname		
 *
 *	Output:
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiGetComputerAssessmentForComputerSet' AND xtype = 'P'
)
        DROP PROCEDURE WiMiGetComputerAssessmentForComputerSet
GO

CREATE PROCEDURE WiMiGetComputerAssessmentForComputerSet
	@tblname varchar(64)='#ComputerAssessmentResults'
AS
BEGIN

--------------------------------------------------------------------------
--Variables set from CURSOR that reads from HardwareAssessmentRule table
--------------------------------------------------------------------------
DECLARE @ruleId int 
DECLARE @severityFailId int 
DECLARE @class varchar(256) 
DECLARE @property varchar(64) 
DECLARE @compexpr varchar(1024) 
DECLARE @sqltype varchar(20)
DECLARE @aggr varchar(10) 

--LHS value of Comparision Expression
DECLARE @lhsexpr varchar(350) SET @lhsexpr = ''
-- Property Value used in Comparision Expression evaluation
DECLARE @value varchar(400) SET @value = ''
-- Group By Clause
DECLARE @grpbyClause varchar(200) set @grpbyClause = ''

DECLARE @severityUnkId int -- Unknown
SELECT @severityUnkId = AssessmentSeverityID 
	from HardwareAssessmentSeverity 
	where AssessmentSeverityMessage LIKE 'Not Inventoried'

DECLARE @severityOkId int -- Pass
SELECT @severityOkId = AssessmentSeverityID 
	from HardwareAssessmentSeverity 
	where AssessmentSeverityMessage LIKE 'Meets requirements'

DECLARE rules_cursor CURSOR FOR
	SELECT	AssessmentRuleID, AssessmentSeverityID, Class, Property,
		ComparisonExpr, SQLType, AggregateFn		
	FROM HardwareAssessmentRule

OPEN rules_cursor
FETCH NEXT FROM rules_cursor
	INTO	@ruleId, @severityFailId, @class, @property, 
		@compexpr, @sqltype, @aggr
WHILE @@FETCH_STATUS = 0
BEGIN

	--------------------------------------------------------------------------
	--Inserts into TABLE for each rule for all Computers in a given OUDN/ OUMatch
	--------------------------------------------------------------------------
	IF @sqltype IS NULL
		-- type of HardwareProperty.Value
		set @sqltype = 'VARCHAR(256)' 

	--LHS value of Comparision Expression	
	SET @lhsExpr = 'hv.Value' 
	-- Property Value used in Comparision Expression evaluation
	SET @value = 'hv.Value'

	IF @sqltype IS NOT NULL -- cast to SQLType
	begin
		SET @lhsExpr = 'CAST(' + @lhsExpr + ' AS ' + @sqltype + ')'	
	end
	IF @aggr IS NOT NULL -- apply Aggregate Function
	begin
		SET @lhsExpr = @aggr + '(' + @lhsExpr + ')'	
		SET @value = 'CAST(' + @lhsExpr + 'AS VARCHAR(256))'
	end

	-- Group By Clause
	IF @aggr IS NOT NULL
		SET @grpbyClause = 'GROUP BY c.ComputerID, c.ComputerOUID, ir.HWDate'
		
	-- Convert data type INT into VARCHAR when constructing SQL query
	-- NOTE: Required for SQL 7.0 (it complains at runtime)
	DECLARE @severityUnkId_var varchar(4)
	SET @severityUnkId_var = CAST(@severityUnkId as varchar(4))
	DECLARE @severityFailId_var varchar(4)
	SET @severityFailId_var = CAST(@severityFailId as varchar(4))
	DECLARE @severityOkId_var varchar(4)
	SET @severityOkId_var = CAST(@severityOkId as varchar(4))
	DECLARE @ruleId_var varchar(5)
	SET @ruleId_var = CAST(@ruleId as varchar(5))
	
	--------------------------------------------------------------------------
	--Inserts into TABLE per Hardware Assessment Rule
	--------------------------------------------------------------------------

	--print ('
	EXEC('
	INSERT INTO ' + @tblname + ' 
	(
		ComputerID,
		ComputerOUID,
		LastHardwareReportDate,
		AssessmentSeverityId,
		AssessmentRuleId
	)
	SELECT 
	c.ComputerID,
	c.ComputerOUID,
	ir.HWDate AS LastHardwareReportDate, 
	CASE
		when ' + @lhsExpr + ' IS NULL then ' + @severityUnkId_var + ' 
		when ' + @lhsExpr + ' ' + @compexpr + ' then ' + @severityFailId_var + ' 
		else ' + @severityOkId_var + '
	END as AssessmentSeverityId,
	' + @ruleId_var + ' as AssessmentRuleId
	FROM	Computer AS c
		LEFT OUTER JOIN InventoryReport AS ir
		ON (ir.ComputerID = c.ComputerID AND ir.UserID = 1)
		LEFT OUTER JOIN HardwareObject AS ho
			INNER JOIN HardwareClass AS hc
			ON (hc.HardwareClassID = ho.HardwareClassID AND hc.Class = ''' + @class + ''')
			INNER JOIN HardwareValue AS hv
			ON (hv.HardwareObjectID = ho.HardwareObjectID)
			INNER JOIN HardwareProperty AS hp
			ON (hp.HardwarePropertyID = hv.HardwarePropertyID AND hp.Property = ''' + @property + ''')
		ON ho.ComputerID = c.ComputerID
	WHERE (
		c.ComputerID IN (Select ComputerID from #ComputerSet)  
		)		
	' + @grpbyClause
	)	
	
	--Reset the Group By Clause
	set @grpbyClause = ''
	---------------------------------------------------------------------------

	FETCH NEXT FROM rules_cursor
		INTO	@ruleId, @severityFailId, @class, @property, 
			@compexpr, @sqltype, @aggr
END

CLOSE rules_cursor
DEALLOCATE rules_cursor

END
GO

EXEC CopyPermission 'WiMiGetComputerAssessmentForComputerSet', 'mgsOSBreakdown'
GO


------------------------------------------------------------------
--STORED PROCEDURE: WiMiValidateNUpdateAssessmentCache
------------------------------------------------------------------

/*
 * DESCRIPTION:
 *
 *	Stored procedure WiMiValidateNUpdateAssessmentCache:  
 *	Validates and updates HardwareAssessmentCache table, which 
 *	in turn may re-create views for Assessment Rules. This is called
 *	from 	2 high level Summary Hardware Assessment stored procedures
 *
 *	Input:
 *		@oudn, @ouMatch
 *
 *	Output:
 *
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiValidateNUpdateAssessmentCache' AND xtype = 'P'
)
        DROP PROCEDURE WiMiValidateNUpdateAssessmentCache
GO

CREATE PROCEDURE WiMiValidateNUpdateAssessmentCache
	@oudn Varchar(800)='%',
	@ouMatch BIT=1
AS
BEGIN

/* 
 ------------------------------------------------------------
 1. Check if HardwareAssessmentRule have been modified since
 Cache was last evalutated
 ------------------------------------------------------------
*/ 

-------------------------------------------------------------------
--i. Delete recordsets from Cache table and Drop Views corresponding
-- to deleted Assessment Rules
-------------------------------------------------------------------
-- REVISIT: User does not have rights to Create and Drop Views
-- EXEC WiMiDeleteOldRulesFromCacheNView @delCacheTbl=1 , @delViews=1 

--Delete from Cache but use existing views
EXEC WiMiDeleteOldRulesFromCacheNView @delCacheTbl=1 , @delViews=0 

-------------------------------------------------------------------
--ii. When Assessment rules have been modified / added
-------------------------------------------------------------------
DECLARE @return BIT --Flag to check if to return out of Proc

BEGIN TRANSACTION

DECLARE @oldestCacheDate DATETIME
SELECT @oldestCacheDate = MIN(CacheEvaluatedDate) FROM HardwareAssessmentCache

DECLARE @latestRuleDate DATETIME
SELECT @latestRuleDate = MAX(RuleModifiedDate) FROM HardwareAssessmentRule WHERE Enabled = 1

CREATE TABLE #Organization(OUID int PRIMARY KEY)
EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

--If Cache table is empty; @oldestCacheDate will be NULL
IF (DATEDIFF(second, @oldestCacheDate, @latestRuleDate) IS NULL )
BEGIN 

/*
 * NOTE: Called procedure currently does not recreate Views;
 * however, other logic for insert vs update into Cache table 
 * needs to know whether it was required or not.
 */
	EXECUTE WiMiPopulateHardwareAssessmentCache 
 		1, -- recreate views
 		0 -- recreate views & populate for all rules

	SET @return = 1 -- Set flag to TRUE
END

--ELSE ....Carry on processing

--If Assessment Rules have been modified, re-do Cache
ELSE IF (DATEDIFF(second, @oldestCacheDate, @latestRuleDate) > 0)
BEGIN
		
	/*
	* NOTE: Called procedure currently does not recreate Views;
	* however, other logic for insert vs update into Cache table 
	* needs to know whether it was required or not.
	*/
		
	/* 
	 * REVISIT 30-September-2002: 
	 * Not executing below procedure for "only recreate views & 
	 * populate for new/modified rules" i.e. @getModifiedRulesOnly=1
	 * as this does not work for scenario when
	 * - a specific is OU selected (not incl. child OUs)
	 * - OU was empty before and now computer(s) have moved into it
	 * - browsed to this OU after going to its child OU	 
 	 */
 	 
	--Deletes old View & creates new one AND populates Cache from View
	--for new/modified Assessment Rules
	EXECUTE WiMiPopulateHardwareAssessmentCache 
 		1, -- recreate views
 		0 -- recreate views & populate for ALL rules
 	
 		
 	SET @return = 0 -- Set flag to FALSE

END 

COMMIT TRANSACTION

IF (@return =1)
	RETURN --No more processing required.
	
--ELSE ....Carry on processing

/* 
 ------------------------------------------------------------
 2. Check if Cache table contains entries for OUDN
 ------------------------------------------------------------
*/ 

BEGIN TRANSACTION

DECLARE @rowCount INT	
SET @rowCount = -1 --Initialize

	-------------------------------------------------------------------
	--i. Update OUIDs for existing records in Cache for computers that
	-- have moved into OU
	-------------------------------------------------------------------
	UPDATE HardwareAssessmentCache
		SET 		
			ComputerOUID = c.ComputerOUID
		FROM 
		#Organization s, 
		Computer c, 
		HardwareAssessmentCache w
		WHERE s.OUID = c.ComputerOUID -- driven by Computer table for correctness 
			AND c.ComputerID = w.ComputerID
			AND c.ComputerOUID <> w.ComputerOUID
			
	-------------------------------------------------------------------
	--ii. Delete recordsets from Cache for Computers that do not exist 
	--in given OUDN anymore (either moved out of or deleted from)
	-------------------------------------------------------------------
	DELETE HardwareAssessmentCache 
		FROM HardwareAssessmentCache w, #Organization s
		WHERE w.ComputerOUID = s.OUID --driven by Cache table
			AND w.ComputerID NOT IN (
				SELECT c.ComputerID FROM Computer c
				WHERE c.ComputerOUID = w.ComputerOUID
			)
			
	-------------------------------------------------------------------
	--iii. Now determine the row count in Cache table for given OUDN
	-------------------------------------------------------------------
	SELECT @rowCount=COUNT(w.ComputerID) FROM HardwareAssessmentCache w, #Organization s
		WHERE w.ComputerOUID = s.OUID

--Cache does not contain any recordset for given OUDN
--then, populate Cache for given OUDN
IF (@rowCount < 1)
BEGIN
	--Populate Cache from View. Does not re-create view(s)
	EXECUTE WiMiPopulateHardwareAssessmentCache 
		0, -- (default) do not re-create views
		0 --(default) no new/modified rules 

END -- end of IF loop
--Cache contains recordsets for given OUDN
--then, populate/update Cache for a set of Computers
ELSE 
BEGIN
	-----------------------------------------------------------------
	--i. Create TABLE to store a set of ComputerIDs
	-----------------------------------------------------------------
	CREATE TABLE #ComputerSet
	(
		ComputerID INT, 
		ExistingComputer BIT -- Values {0:Add new | 1: Update Existing}
	)

	-----------------------------------------------------------------
	--ii. Check if Cache table contains all Computers for given OU
	--and if computer records been evaluated with lastest Inventory.
	--Then determine computer set & insert into #ComputerSet table
	-----------------------------------------------------------------	
	EXECUTE  WiMiGetComputerSetFromComputerNInventoryReportTbl

	--------------------------------------------------------------------
	--iii. Create #ComputerAssessmentResults table based on
	--a set of computers and Populate with assessment
	--------------------------------------------------------------------
	CREATE TABLE #ComputerAssessmentResults
	(
		ComputerID INT,
		ComputerOUID INT,
		LastHardwareReportDate DATETIME,
		AssessmentSeverityId INT,
		AssessmentRuleId INT
	)
	
	EXECUTE WiMiGetComputerAssessmentForComputerSet
		'#ComputerAssessmentResults' --table name
	
	-------------------------------------------------------------------
	--iv. Update *existing* records in Cache table 
	-------------------------------------------------------------------	

	UPDATE HardwareAssessmentCache
	SET 		
		ComputerOUID = tmp.ComputerOUID,
		LastHardwareReportDate = tmp.LastHardwareReportDate,
		AssessmentSeverityID = tmp.AssessmentSeverityID,
		CacheEvaluatedDate = GetDate()
	FROM
	(
		SELECT 
			ComputerID, 
			ComputerOUID,
			LastHardwareReportDate,
			AssessmentRuleID,
			AssessmentSeverityID
		FROM #ComputerAssessmentResults
	) AS tmp, HardwareAssessmentCache AS w
	WHERE w.ComputerID = tmp.ComputerID
	AND w.AssessmentRuleID = tmp.AssessmentRuleID

	-------------------------------------------------------------------
	--v. Insert *new* records into Cache table 
	-------------------------------------------------------------------	
	INSERT INTO HardwareAssessmentCache
	(
		ComputerID, 
		ComputerOUID, 
		LastHardwareReportDate, 
		AssessmentRuleID,
		AssessmentSeverityID, 
		CacheEvaluatedDate
	)
	SELECT 
		t.ComputerID, 
		t.ComputerOUID,
		t.LastHardwareReportDate,		
		t.AssessmentRuleID,
		t.AssessmentSeverityID,
		GetDate() AS CacheEvaluatedDate
	FROM #ComputerAssessmentResults t, #ComputerSet cs
	WHERE 
		t.ComputerID = cs.ComputerID 
		AND cs.ExistingComputer = 0 -- computer does not exist in Cache

	--------------------------------------------------------------------
	--vi. Drop temporary tables
	--------------------------------------------------------------------
	DROP TABLE #ComputerAssessmentResults
	DROP TABLE #ComputerSet
	
END -- end of ELSE loop

COMMIT TRANSACTION

END -- end of BEGIN loop

GO

EXEC CopyPermission 'WiMiValidateNUpdateAssessmentCache', 'mgsOSBreakdown'

/*
 * $Header$
 *
 * DESCRIPTION:
 *
 *	Stored procedure WiMiHardwareDisposition: Obtain hardware
 *	disposition information for computers.
 *
 *	Input:
 *		@oudn, @ouMatch, @compID, @disposition
 *
 *	Output:
 *		ComputerID, ComputerName, OUDN,
 *		LastHardwareReportDate, Disposition
 *
 *		Disposition is one of 'Not inventoried', 'Requires
 *		upgrade', 'Requires replacement' or 'Meets
 *		requirements'
 *
 * TO THINK ABOUT: When inventory has been reported, but a property
 * value is NULL (i.e. the property was not reported in the
 * inventory), what should we return? Currently "Not inventoried" is
 * returned. This is typically displayed as "missing inventory
 * information" to users.
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiHardwareDisposition' AND xtype = 'P'
)
        DROP PROCEDURE WiMiHardwareDisposition
GO

CREATE PROCEDURE [WiMiHardwareDisposition]
	@oudn VARCHAR(800) = '%',	-- Default: For all OUs
	@ouMatch BIT = 1,			-- Include sub-OUs. Default: 1 i.e. True
	@disposition VARCHAR(20) = NULL,	-- Disposition to filter on	
	@groupID INT, 			--filter on rollout group
	@grpfilter INT=0 			-- do not filter
AS
BEGIN

-- Validates and Updates HardwareAssessmentCache table
EXEC WiMiValidateNUpdateAssessmentCache @oudn, @ouMatch

IF @disposition IS NULL
	SET @disposition = '%'
	
CREATE TABLE #Organization(OUID int PRIMARY KEY)
EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

	IF @grpfilter <> 0 -- do filter
		SELECT 
			tmp.ComputerID,
			tmp.ComputerName,			
			tmp.OUDN,
			tmp.OldName,
			tmp.NewName,
			tmp.LastHardwareReportDate,
			sev.AssessmentSeverityMessage as Disposition
		FROM
		(
			SELECT 
			cache.ComputerID,
			c.ComputerCN as ComputerName, -- current name
			dbo.OUName(s.OUID) as OUDN,
			CASE 
				WHEN d1.DN IS NULL THEN map.[name]
				WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
				ELSE map.[name] + ' (' + d1.DN + ')'	
			END as OldName,
			CASE 
				WHEN d2.DN IS NULL THEN map.newName
				WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
				ELSE map.newName + ' (' + d2.DN + ')'	
			END as NewName,
			MAX(cache.LastHardwareReportDate) as LastHardwareReportDate,			
			MAX(sev.AssessmentSeverityNumber) as AssessmentSeverityNumber
			FROM 	
			(#Organization AS s INNER JOIN HardwareAssessmentCache AS cache
			 ON (cache.ComputerOUID = s.OUID)	 
				INNER JOIN HardwareAssessmentSeverity AS sev
				ON cache.AssessmentSeverityID = sev.AssessmentSeverityID
			)	
			INNER JOIN (
				Computer AS c 
					LEFT OUTER JOIN (
					Namemap as map 
						INNER JOIN Domain as d1
						ON map.Domain = d1.OrganizationID
						INNER JOIN Domain as d2
						ON map.newDomain = d2.OrganizationID
					)
					ON c.ComputerID = map.currentID
				) -- name-mapping for pre and post rollout computer names
				LEFT OUTER JOIN ( 
					RolloutGroup as grp INNER JOIN RolloutGroupMember as mem
					ON grp.GroupID = mem.GroupID
				)
				ON c.ComputerID = mem.MemberID
			ON cache.ComputerID = c.ComputerID
			WHERE grp.GroupID = @groupID							
			GROUP BY cache.ComputerID, c.ComputerCN, dbo.OUName(s.OUID), map.[name], d1.DN, map.newName, d2.DN, s.OUID
		) AS tmp, HardwareAssessmentSeverity AS sev
		WHERE tmp.AssessmentSeverityNumber = sev.AssessmentSeverityNumber
			AND sev.AssessmentSeverityMessage LIKE @disposition
	ELSE
		SELECT 
			tmp.ComputerID,
			tmp.ComputerName,			
			tmp.OUDN,
			tmp.OldName,
			tmp.NewName,
			tmp.LastHardwareReportDate,
			sev.AssessmentSeverityMessage as Disposition
		FROM
		(
			SELECT 
			cache.ComputerID,
			c.ComputerCN as ComputerName, -- current name			
			dbo.OUName(s.OUID) as OUDN,
			CASE 
				WHEN d1.DN IS NULL THEN map.[name]
				WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
				ELSE map.[name] + ' (' + d1.DN + ')'	
			END as OldName,
			CASE 
				WHEN d2.DN IS NULL THEN map.newName
				WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
				ELSE map.newName + ' (' + d2.DN + ')'	
			END as NewName,
			MAX(cache.LastHardwareReportDate) as LastHardwareReportDate,
			MAX(sev.AssessmentSeverityNumber) as AssessmentSeverityNumber
			FROM 	
			(#Organization AS s INNER JOIN HardwareAssessmentCache AS cache
			ON (cache.ComputerOUID = s.OUID)	 
				INNER JOIN HardwareAssessmentSeverity AS sev
				ON cache.AssessmentSeverityID = sev.AssessmentSeverityID
			)	
			INNER JOIN 
			(Computer AS c 
				LEFT OUTER JOIN 
				(Namemap as map
					INNER JOIN Domain as d1
					ON map.Domain = d1.OrganizationID
					INNER JOIN Domain as d2
					ON map.newDomain = d2.OrganizationID
				)
				ON c.ComputerID = map.currentID
			) -- name-mapping for pre and post rollout computer names		
			ON cache.ComputerID = c.ComputerID
		GROUP BY cache.ComputerID, c.ComputerCN, dbo.OUName(s.OUID), map.[name], d1.DN, map.newName, d2.DN, s.OUID
		) AS tmp, HardwareAssessmentSeverity AS sev
		WHERE tmp.AssessmentSeverityNumber = sev.AssessmentSeverityNumber
			AND sev.AssessmentSeverityMessage LIKE @disposition
END
GO

EXEC CopyPermission 'WiMiHardwareDisposition', 'mgsOSBreakdown'
GO

/*
 * $Header$
 *
 * DESCRIPTION:
 *
 *	Stored procuedre WiMiHardwareDispositionDetails: Obtain detailed
 *	hardware disposition information for a specified computer.
 *
 *	Input:
 *		@compID
 *
 *	Output:
 *		ComputerID, ComputerCN, OperatingSystem,
 *		LastHardwareReportDate, Disposition, OUDN,
 *		Value*, Message*, Disposition*
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiHardwareDispositionDetails' AND xtype = 'P'
)
        DROP PROCEDURE WiMiHardwareDispositionDetails
GO

CREATE PROCEDURE [WiMiHardwareDispositionDetails]
	@compID INT	-- ID of computer to get disposition information for
AS
BEGIN
-----------------------------------
--Check if Views are upto date
-----------------------------------

/*
 * REVISIT: User does not have rights to Create and Drop Views.
 * Currently, this updated separately.
 *
 * EXECUTE WiMiHardwareAssessmentCreateViewsOnRules 
 *	'%', --Do all OUs
 *	1, --Include child OUs
 *	1 --Get new/modified Rules
 */
 
----------------------------------------

CREATE TABLE #ComputerAssessmentDetails
(
	ComputerID INT,
	OperatingSystem VARCHAR(128) COLLATE database_default,
	LastHardwareReportDate DATETIME,
	AssessmentSeverityNumber INT,
	AssessmentSeverityMessage VARCHAR(64) COLLATE database_default,
	AssessmentMessage VARCHAR(256) COLLATE database_default,
	AssessmentRuleID INT,
	Class VARCHAR(256) COLLATE database_default,
	Property VARCHAR(256) COLLATE database_default,
	PropertyValue VARCHAR(256) COLLATE database_default
)
-----------------------------------
--Build the following dynamically
-----------------------------------
DECLARE @viewName Varchar(64)

DECLARE rulesID_cursor CURSOR FOR
	SELECT DISTINCT r.AssessmentRuleID
	FROM HardwareAssessmentRule r
	WHERE r.Enabled = 1 
	
OPEN rulesID_cursor

DECLARE @rulesID  int
FETCH NEXT FROM rulesID_cursor INTO	@rulesID
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @viewName = 'HardwareAssessmentView_onRule' + CAST(@rulesID as Varchar(4))
	
	--Check if view exists as it is created separately
	IF EXISTS (
		SELECT * FROM dbo.sysobjects
		WHERE [name] = @viewname AND xtype = 'V'
	)
	BEGIN
		DECLARE @insertSQL nvarchar(4000)

		--Get assessment results for a Rule from its corresponding View
		SET @insertSQL =
		N'INSERT INTO #ComputerAssessmentDetails
		(
			ComputerID,
			OperatingSystem,
			LastHardwareReportDate,
			AssessmentSeverityNumber,
			AssessmentSeverityMessage,
			AssessmentMessage,
			AssessmentRuleID,
			Class,
			Property,
			PropertyValue
		)
		SELECT	v.ComputerID,
			os.OperatingSystemName,
			v.LastHardwareReportDate,
			sev.AssessmentSeverityNumber,
			sev.AssessmentSeverityMessage,
			v.AssessmentMessage,
			v.AssessmentRuleID,
			v.Class,
			v.Property,
			v.PropertyValue
		FROM	'+ @viewname + ' as v,
			Computer as c
			LEFT OUTER JOIN OperatingSystem as os
				ON os.OperatingSystemID = c.OperatingSystemID,
			HardwareAssessmentSeverity as sev
		WHERE	v.ComputerID = c.ComputerID
			AND v.AssessmentSeverityID = sev.AssessmentSeverityID
			AND v.ComputerID = ' + cast(@compID as varchar(10))

		EXEC sp_executesql @insertSQL		
	 
	END

	FETCH NEXT FROM rulesID_cursor INTO	@rulesID
END
CLOSE rulesID_cursor
DEALLOCATE rulesID_cursor

SELECT * FROM #ComputerAssessmentDetails

DROP TABLE #ComputerAssessmentDetails

END
GO

EXEC CopyPermission 'WiMiHardwareDispositionDetails', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiHardwareDispositionSummary
 *	Input:
 * 	- @oudn: OU DN to search in. Default: '%' (= all OUs)
 *	- @ouMatch: match sub OUs? Default: true
 *
 *	Returns:
 *	- Disposition, Count
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiHardwareDispositionSummary' AND xtype = 'P'
)
        DROP PROCEDURE WiMiHardwareDispositionSummary
GO

CREATE PROCEDURE [WiMiHardwareDispositionSummary]
	@oudn VARCHAR(800) = '%', --Default: For all OUs
	@ouMatch BIT=1, --Include sub-OUs. Default: 1 (i.e. True)
	@groupID INT, --filter on rollout group
	@grpfilter INT=0 -- do not filter
AS
BEGIN

-- Validates and Updates HardwareAssessmentCache table
EXEC WiMiValidateNUpdateAssessmentCache @oudn, @ouMatch

	CREATE TABLE #Organization(OUID int PRIMARY KEY)
	EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

	IF @grpfilter <> 0 -- do filter
		SELECT
			tmp.Disposition,
			COUNT (DISTINCT tmp.ComputerID)as Total			
		FROM
		(
			SELECT
			cache.ComputerID,
			(
				SELECT AssessmentSeverityMessage
				FROM HardwareAssessmentSeverity
				WHERE AssessmentSeverityNumber = MAX(sev.AssessmentSeverityNumber) 
			)as Disposition		
			FROM 	
			(	#Organization AS s INNER JOIN HardwareAssessmentCache AS cache 
				ON (s.OUID = cache.ComputerOUID) 
					INNER JOIN HardwareAssessmentSeverity AS sev
					ON cache.AssessmentSeverityID = sev.AssessmentSeverityID
			)
			LEFT OUTER JOIN 
			(
				RolloutGroup as grp INNER JOIN RolloutGroupMember as mem
				ON grp.GroupID = mem.GroupID
			)
			ON cache.ComputerID = mem.MemberID					
			WHERE		
				grp.GroupID =  @groupID					
			GROUP By cache.ComputerID
		) as tmp --contains assessment for individual computer
		GROUP By tmp.Disposition
	ELSE
		SELECT
			tmp.Disposition,
			COUNT (DISTINCT tmp.ComputerID)as Total		
		FROM
		(
			SELECT
			cache.ComputerID,
			(
				SELECT AssessmentSeverityMessage
				FROM HardwareAssessmentSeverity
				WHERE AssessmentSeverityNumber = MAX(sev.AssessmentSeverityNumber) 
			)as Disposition		
			FROM 	#Organization AS s, 
				HardwareAssessmentCache AS cache, 
				HardwareAssessmentSeverity AS sev
			WHERE
				cache.ComputerOUID = s.OUID
				AND cache.AssessmentSeverityID = sev.AssessmentSeverityID
			GROUP By cache.ComputerID
		) as tmp --contains assessment for individual computer
		GROUP By tmp.Disposition
END
GO

EXEC CopyPermission 'WiMiHardwareDispositionSummary', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiInventoryStatus
 *	Input:
 * 	- @oudn: OU DN to search in. Default: '%' (= all OUs)
 *	- @ouMatch: match sub OUs? Default: true
 *
 *	Returns:
 *	- Status, Total
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiInventoryStatus' AND xtype = 'P'
)
        DROP PROCEDURE WiMiInventoryStatus
GO

CREATE PROCEDURE [WiMiInventoryStatus]
	@oudn VARCHAR(800)='%', 
	@ouMatch BIT=1, --Values:[0=do exact OU Match | 1=include child-OUs in match]
	@allTargets INT=0, --Values:[0=only targets that have reported inventory | 1=all targets  | 2: Not Inventoried ]
	@groupID INT,
	@grpfilter INT=0
AS

BEGIN

CREATE TABLE #Organization(OUID int PRIMARY KEY)
EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

IF @allTargets < 2 -- ALL items or Inventoried items
	BEGIN 
		IF @grpfilter <> 0 -- do filter
			SELECT 
				c.ComputerID,
				c.ComputerCN AS [ComputerName], -- current name
				dbo.OUName(s.OUID) AS [OUDN],
				CASE 
					WHEN d1.DN IS NULL THEN map.[name]
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
					ELSE map.[name] + ' (' + d1.DN + ')'	
				END as OldName,
				CASE 
					WHEN d2.DN IS NULL THEN map.newName
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
					ELSE map.newName + ' (' + d2.DN + ')'	
				END as NewName,
				ir.SWDate AS [LastSoftwareReportDate],		
				ir.HWDate AS [LastHardwareReportDate]			
			FROM 
			(RolloutGroup as grp INNER JOIN RolloutGroupMember as mem ON grp.GroupID = mem.GroupID)
			RIGHT OUTER JOIN
				(#Organization as s INNER JOIN 
					(Computer AS c LEFT OUTER JOIN 
						(Namemap AS map
							INNER JOIN Domain AS d1
							ON map.Domain = d1.OrganizationID
							INNER JOIN Domain AS d2
							ON map.newDomain = d2.OrganizationID
						)
						ON c.ComputerID = map.currentID		
					) -- name-mapping for pre and post rollout computer names
					ON (s.OUID = c.ComputerOUID)
				)
				LEFT OUTER JOIN InventoryReport AS ir
				ON c.ComputerID = ir.ComputerID AND ir.UserID = 1
				--reported "System" User i.e. All Users on Computer
			ON mem.MemberID = c.ComputerID			
			WHERE 
				grp.GroupID = @groupID
				AND (	@allTargets = 1
					OR SWDate IS NOT NULL
					OR HWDate IS NOT NULL
				) -- atleast one of Dates is NOT NULL			
			ORDER BY dbo.OUName(s.OUID), c.ComputerCN
		ELSE
			SELECT 
				c.ComputerID,
				c.ComputerCN AS [ComputerName], -- current name
				dbo.OUName(s.OUID) AS [OUDN],
				CASE 
					WHEN d1.DN IS NULL THEN map.[name]
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
					ELSE map.[name] + ' (' + d1.DN + ')'	
				END as OldName,
				CASE 
					WHEN d2.DN IS NULL THEN map.newName
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
					ELSE map.newName + ' (' + d2.DN + ')'	
				END as NewName,
				ir.SWDate AS [LastSoftwareReportDate],		
				ir.HWDate AS [LastHardwareReportDate]	
			FROM 
			(#Organization AS s INNER JOIN 
				(Computer AS c LEFT OUTER JOIN 
						(Namemap AS map
							INNER JOIN Domain AS d1
							ON map.Domain = d1.OrganizationID
							INNER JOIN Domain AS d2
							ON map.newDomain = d2.OrganizationID
						)
						ON c.ComputerID = map.currentID		
				) -- name-mapping for pre and post rollout computer names
				ON (c.ComputerOUID = s.OUID)
			)
			LEFT OUTER JOIN InventoryReport AS ir
			ON c.ComputerID = ir.ComputerID AND ir.UserID = 1
			--reported "System" User i.e. All Users on Computer	
			WHERE 
				(	@allTargets = 1
					OR SWDate IS NOT NULL
					OR HWDate IS NOT NULL
				) -- atleast one of Dates is NOT NULL	
			ORDER BY dbo.OUName(s.OUID), c.ComputerCN	
	END
ELSE ---Only Not Inventoried items
	BEGIN
		IF @grpfilter <> 0 -- do filter
			SELECT 
				c.ComputerID,
				c.ComputerCN AS [ComputerName], -- current name
				dbo.OUName(s.OUID) AS [OUDN],
				CASE 
					WHEN d1.DN IS NULL THEN map.[name]
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
					ELSE map.[name] + ' (' + d1.DN + ')'	
				END as OldName,
				CASE 
					WHEN d2.DN IS NULL THEN map.newName
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
					ELSE map.newName + ' (' + d2.DN + ')'	
				END as NewName,
				ir.SWDate AS [LastSoftwareReportDate],		
				ir.HWDate AS [LastHardwareReportDate]	
			FROM 
			(RolloutGroup as grp INNER JOIN RolloutGroupMember as mem ON grp.GroupID = mem.GroupID)
			RIGHT OUTER JOIN	
				(#Organization AS s 
					INNER JOIN 
					(Computer AS c 
						LEFT OUTER JOIN 
						(Namemap AS map
							INNER JOIN Domain AS d1
							ON map.Domain = d1.OrganizationID
							INNER JOIN Domain AS d2
							ON map.newDomain = d2.OrganizationID
						)
						ON c.ComputerID = map.currentID		
					) -- name-mapping for pre and post rollout computer names
					ON (c.ComputerOUID = s.OUID)
				)
				LEFT OUTER JOIN InventoryReport AS ir
				ON c.ComputerID = ir.ComputerID AND ir.UserID = 1
				--reported "System" User i.e. All Users on Computer
			ON mem.MemberID = c.ComputerID	
			WHERE
				grp.GroupID = @groupID 			
				AND (	SWDate IS NULL
					AND HWDate IS NULL
				)  -- Both Dates are NULL
		ELSE
			SELECT 
				c.ComputerID,
				c.ComputerCN AS [ComputerName], -- current name
				dbo.OUName(s.OUID) AS [OUDN],
				CASE 
					WHEN d1.DN IS NULL THEN map.[name]
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d1.DN)) = d1.DN THEN map.[name]
					ELSE map.[name] + ' (' + d1.DN + ')'	
				END as OldName,
				CASE 
					WHEN d2.DN IS NULL THEN map.newName
					WHEN RIGHT(dbo.OUName(s.OUID), LEN(d2.DN)) = d2.DN THEN map.newName
					ELSE map.newName + ' (' + d2.DN + ')'	
				END as NewName,
				ir.SWDate AS [LastSoftwareReportDate],		
				ir.HWDate AS [LastHardwareReportDate]	
			FROM 
			(#Organization AS s 
				INNER JOIN 
				(Computer AS c 
					LEFT OUTER JOIN 
					(Namemap AS map
						INNER JOIN Domain AS d1
						ON map.Domain = d1.OrganizationID
						INNER JOIN Domain AS d2
						ON map.newDomain = d2.OrganizationID
					)
					ON c.ComputerID = map.currentID		
				) -- name-mapping for pre and post rollout computer names
				ON (c.ComputerOUID = s.OUID)
			)
			LEFT OUTER JOIN InventoryReport AS ir
			ON c.ComputerID = ir.ComputerID AND ir.UserID = 1
			--reported "System" User i.e. All Users on Computer	
			WHERE 			
				(	SWDate IS NULL
					AND HWDate IS NULL
				)  -- Both Dates are NULL	
	END
END

RETURN

GO

CopyPermission 'WiMiInventoryStatus', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiInventoryStatusSummary
 *	Input:
 * 	- @oudn: OU DN to search in. Default: '%' (= all OUs)
 *	- @ouMatch: match sub OUs? Default: true
 *
 *	Returns:
 *	- Status, Total
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiInventoryStatusSummary' AND xtype = 'P'
)
        DROP PROCEDURE WiMiInventoryStatusSummary
GO

CREATE PROCEDURE [WiMiInventoryStatusSummary]
	@oudn VARCHAR(800) = '%',	--Default: For all OUs
	@ouMatch BIT=1,			--Include sub-OUs? Default: 1
	@groupID INT, 			--filter on rollout group
	@grpfilter INT=0 			-- do not filter
AS
	BEGIN
		CREATE TABLE #Organization(OUID int PRIMARY KEY)
		EXEC OrganizationIdentifyDescendentsByOUDN @oudn, @ouMatch, 0

		IF @grpfilter <> 0 -- do filter

			SELECT
			'Inventoried' as Status,
			COUNT(c.ComputerID) as Total
			FROM
			( 
				RolloutGroup as grp INNER JOIN RolloutGroupMember as mem
				ON grp.GroupID = mem.GroupID
			)
			RIGHT OUTER JOIN
				( #Organization as s INNER JOIN Computer as c 
					ON (s.OUID = c.ComputerOUID)
				)
				LEFT OUTER JOIN InventoryReport as ir
				ON (c.ComputerID = ir.ComputerID AND ir.UserID=1)
			ON mem.MemberID = c.ComputerID
			WHERE ir.HWDate IS NOT NULL AND grp.GroupID = @groupID
			
			UNION
			
			SELECT
				'Not inventoried' as Status,
				COUNT(c.ComputerID) as Total
			FROM
			( 
				RolloutGroup as grp INNER JOIN RolloutGroupMember as mem
				ON grp.GroupID = mem.GroupID
			)
			RIGHT OUTER JOIN
				( #Organization as s INNER JOIN Computer as c 
					ON (s.OUID = c.ComputerOUID)
				)
				LEFT OUTER JOIN InventoryReport as ir
				ON (c.ComputerID = ir.ComputerID AND ir.UserID=1)
			ON mem.MemberID = c.ComputerID
			WHERE ir.HWDate IS NULL AND grp.GroupID = @groupID
		
		ELSE
		
			SELECT
				'Inventoried' as Status,
				COUNT(c.ComputerID) as Total
			FROM
			( #Organization as s INNER JOIN Computer as c 
				ON (s.OUID = c.ComputerOUID)
			)
			LEFT OUTER JOIN InventoryReport as ir
			ON (c.ComputerID = ir.ComputerID AND ir.UserID=1)		
			WHERE ir.HWDate IS NOT NULL
			
			UNION
			
			SELECT
				'Not inventoried' as Status,
				COUNT(c.ComputerID) as Total
			FROM
				( #Organization as s INNER JOIN Computer as c 
					ON (s.OUID = c.ComputerOUID)
				)
				LEFT OUTER JOIN InventoryReport as ir
				ON (c.ComputerID = ir.ComputerID AND ir.UserID=1)		
			WHERE ir.HWDate IS NULL
	END
GO

CopyPermission 'WiMiInventoryStatusSummary', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiMigrationProgress
 *	Input:
 *		@FromDate, @TillDate, @state, @compCN
 *
 *	Returns:
 *		ComputerID, ComputerName, OUDN, State
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiMigrationProgress' AND xtype = 'P'
)
        DROP PROCEDURE WiMiMigrationProgress
GO

CREATE PROCEDURE [WiMiMigrationProgress]
	@FromDate	DATETIME,
	@TillDate	DATETIME,
	@state VARCHAR(20) = NULL,	--State to filter on	
	@groupID INT,   --GroupID to filter on
	@grpfilter INT= 0 -- do not filter on group
AS
BEGIN

	IF @state IS NULL
		SET @state = '%'

	-- Retrieve Summary Data for ALL GROUPs
	CREATE TABLE #parentListTbl
	(	
		GroupID int,
		GroupFullName nvarchar(800) COLLATE database_default
	)

	DECLARE grpList_cursor CURSOR FOR
		Select GroupID, ParentID from RolloutGroup

	DECLARE @grpID int
	DECLARE @fullName nvarchar(800)
	DECLARE @parentID int

	OPEN grpList_cursor
	FETCH NEXT FROM grpList_cursor INTO @grpID, @parentID
	WHILE @@FETCH_STATUS =0
	BEGIN
		--Retrieve parent name
		EXECUTE RolloutGroupParentName @grpID, @outFullName = @fullName OUTPUT 	
		INSERT INTO #parentListTbl VALUES ( @grpID, @fullName ) 
		SET @fullName = NULL -- reset	
		FETCH NEXT FROM grpList_cursor INTO @grpID, @parentID
	END

	CLOSE grpList_cursor
	DEALLOCATE grpList_cursor
	
	IF @grpfilter <> 0 -- do filter
		SELECT 
			SessionName
			State, 
			ComputerID, 
			ISNULL(ComputerCN, SessionName) AS [ComputerName],  -- current name
			OU AS [OUDN], 
			OldName,
			NewName, 
			MemberID, 
			GroupID, 
			GroupFullName,
			LastStep,
			LastStepDescription,
			StepCount,
			LastDateTime
		FROM
		(
			SELECT 
				ms.SessionName,
				ms.State, 
				c.ComputerID,
				c.ComputerCN,
				dbo.OUName(c.ComputerOUID) AS OU,
				CASE 
					WHEN d1.DN IS NULL THEN map.[name]
					WHEN RIGHT(dbo.OUName(c.ComputerOUID), LEN(d1.DN)) = d1.DN THEN map.[name]
					ELSE map.[name] + ' (' + d1.DN + ')'	
				END as OldName,
				CASE 
					WHEN d2.DN IS NULL THEN map.newName
					WHEN RIGHT(dbo.OUName(c.ComputerOUID), LEN(d2.DN)) = d2.DN THEN map.newName
					ELSE map.newName + ' (' + d2.DN + ')'	
				END as NewName,
				ms.LastStep,
				ms.LastStepDescription,
				ms.StepCount,
				ms.LastDateTime
			FROM		
				WiMiMigrationStateByComputer AS ms
				LEFT OUTER JOIN 	
					(Computer AS c 
						LEFT OUTER JOIN 
						(Namemap as map
							INNER JOIN Domain as d1
							ON map.Domain = d1.OrganizationID
							INNER JOIN Domain as d2
							ON map.newDomain = d2.OrganizationID
						)
						ON c.ComputerID = map.currentID		
					) -- name-mapping for pre and post rollout computer names
				ON ms.ComputerID = c.ComputerID
		) as t1
		LEFT OUTER JOIN
		(
			SELECT 
				mem.MemberID,
				grp.GroupID,
				parent.GroupFullName
			FROM	
				#parentListTbl as parent, 
				RolloutGroup as grp, 
				RolloutGroupMember as mem
			WHERE	
				parent.GroupID = grp.GroupID		
				AND grp.GroupID = mem.GroupID 
		) as t2		
		ON t1.ComputerID = t2.MemberID	
			
		WHERE	t2.GroupID = @groupID					
		  AND	t1.State LIKE @state
		  AND	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0

	ELSE
		SELECT 
			ms.SessionName,
			ms.State, 
			c.ComputerID,
			ISNULL(c.ComputerCN, ms.SessionName) AS [ComputerName], -- current name
			dbo.OUName(c.ComputerOUID) AS [OUDN],
			CASE 
				WHEN d1.DN IS NULL THEN map.[name]
				WHEN RIGHT(dbo.OUName(c.ComputerOUID), LEN(d1.DN)) = d1.DN THEN map.[name]
				ELSE map.[name] + ' (' + d1.DN + ')'	
			END as OldName,
			CASE 
				WHEN d2.DN IS NULL THEN map.newName
				WHEN RIGHT(dbo.OUName(c.ComputerOUID), LEN(d2.DN)) = d2.DN THEN map.newName
				ELSE map.newName + ' (' + d2.DN + ')'	
			END as NewName,
			NULL as MemberID,
			NULL as GroupID,
			NULL as GroupFullName,
			ms.LastStep,
			ms.LastStepDescription,
			ms.StepCount,
			ms.LastDateTime
		FROM		
			WiMiMigrationStateByComputer AS ms
			LEFT OUTER JOIN 	
				(Computer AS c 
					LEFT OUTER JOIN 
					(Namemap AS map
						INNER JOIN Domain AS d1
						ON map.Domain = d1.OrganizationID
						INNER JOIN Domain AS d2
						ON map.newDomain = d2.OrganizationID
					)
					ON c.ComputerID = map.currentID		
				) -- name-mapping for pre and post rollout computer names
			ON ms.ComputerID = c.ComputerID
		WHERE	ms.State LIKE @state
		  AND	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0

END
GO


CopyPermission 'WiMiMigrationProgress', 'mgsOSBreakdown'
GO

/*
 * $ Exp $
 *
 * DESCRIPTION: Stored Procedure: WiMiMigrationProgressFailReason
 *	Input:
 *		@sessName
 *
 *	Returns:
 *		PackageName, Version, PolicyAction, FailReason, PackageFullName
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiMigrationProgressFailReason' AND xtype = 'P'
)
        DROP PROCEDURE WiMiMigrationProgressFailReason
GO


CREATE PROCEDURE WiMiMigrationProgressFailReason
	@sessName AS NVARCHAR(64)
AS
BEGIN
	SELECT	r.Phase,
		r.StepNumber,
		r.Description,
		LOWER(r.Status) AS Status,
		r.StatusMessage,
		NULL AS PackageName,
		NULL AS PackageVersion,
		NULL AS PackageFullName
	FROM	RolloutStatus AS r, RolloutStatusType AS t
	WHERE	r.SessionName = @sessName
			AND r.RolloutStatusTypeID = t.RolloutStatusTypeID
			AND t.[Name] = 'ComputerBuild'
	UNION ALL
	SELECT	NULL,
		NULL,
		NULL,
		i.Result,
		r.ReasonText AS FailReason,
		pf.PackageName,
		pv.Version,
		pp.PackageFullName
	FROM	Installation AS i
		INNER JOIN RolloutStatus AS rs
			ON i.ComputerID = rs.ComputerID
			AND rs.SessionName = @sessName
		LEFT OUTER JOIN Reason AS r
			ON i.FailReasonID = r.ReasonID,
		PackageVersion AS pv,
		PackageFamily AS pf,
		PackagePath AS pp
	WHERE	i.UserID = 1			-- For SYSTEM/all
	AND	'success' <> i.Result
	AND	'notrequired' <> i.Result
	AND	i.PackageVersionID = pv.PackageVersionID
	AND	pv.PackageFamilyID = pf.PackageFamilyID
	AND	pv.PackagePathID = pp.PackagePathID
	ORDER BY PackageName, PackageVersion, StepNumber
END
GO

CopyPermission 'WiMiMigrationProgressFailReason', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiMigrationProgressSummary
 *	Input:
 * 	- @FromDate.
 *	- @TillDate.
 *
 *	Returns:
 *	- State, Total
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiMigrationProgressSummary' AND xtype = 'P'
)
        DROP PROCEDURE WiMiMigrationProgressSummary
GO

CREATE PROCEDURE [WiMiMigrationProgressSummary]
	@FromDate	DATETIME,
	@TillDate	DATETIME,
	@groupID	INT, --filter on rollout group
	@grpfilter	INT=0 -- do not filter
AS
BEGIN
	IF @grpfilter <> 0 -- do filter
		SELECT 
			ms.State, 
			COUNT(ms.SessionName) as Total
		FROM	WiMiMigrationStateByComputer as ms
		LEFT OUTER JOIN
		(
			SELECT 
				mem.MemberID,
				grp.GroupID
			FROM						 
				RolloutGroup as grp, 
				RolloutGroupMember as mem
			WHERE	
				grp.GroupID = mem.GroupID 
		) as t2		
		ON ms.ComputerID = t2.MemberID	
		WHERE	t2.GroupID = @groupID
		  AND	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0
		
		GROUP BY ms.State
		ORDER BY ms.State	

	ELSE
		SELECT 
			ms.State, 
			COUNT(ms.SessionName) as Total
		FROM	
			WiMiMigrationStateByComputer as ms
		WHERE	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0

		GROUP BY State
		ORDER BY State

END

GO

CopyPermission 'WiMiMigrationProgressSummary', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiImageCaptureProgress
 *	Input:
 *		@FromDate, @TillDate, @state
 *
 *	Returns:
 *		ComputerID, ComputerName, OUDN, State
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiImageCaptureProgress' AND xtype = 'P'
)
        DROP PROCEDURE WiMiImageCaptureProgress
GO

CREATE PROCEDURE [WiMiImageCaptureProgress]
	@FromDate	DATETIME,
	@TillDate	DATETIME,
	@state VARCHAR(50) = NULL
AS
BEGIN

	IF @state IS NULL
		SET @state = '%'
	
	SELECT 
		ms.SessionName,
		ms.State, 
		c.ComputerID,
		ISNULL(c.ComputerCN, ms.SessionName) AS [ComputerName], -- current name
		dbo.OUName(c.ComputerOUID) AS [OUDN],
		ms.LastStep,
		ms.LastStepDescription,
		ms.StepCount,
		ms.LastDateTime,
		ms.DataImageCaptureLocation,
		ms.ImageCaptureDateTime
	FROM		
		WiMiImageCaptureStateByComputer AS ms
		LEFT OUTER JOIN 	
			(Computer AS c 
				LEFT OUTER JOIN 
				(Namemap AS map
					INNER JOIN Domain AS d1
					ON map.Domain = d1.OrganizationID
					INNER JOIN Domain AS d2
					ON map.newDomain = d2.OrganizationID
				)
				ON c.ComputerID = map.currentID		
			) -- name-mapping for pre and post rollout computer names
		ON ms.ComputerID = c.ComputerID
	WHERE	ms.State LIKE @state
	  AND	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
	  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0

END
GO


CopyPermission 'WiMiImageCaptureProgress', 'mgsOSBreakdown'
GO

/*
 * $ Exp $
 *
 * DESCRIPTION: Stored Procedure: WiMiImageCaptureProgressInformation
 *	Input:
 *		@sessName
 *
 *	Returns:
 *		PackageName, Version, PolicyAction, FailReason, PackageFullName
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiImageCaptureProgressInformation' AND xtype = 'P'
)
        DROP PROCEDURE WiMiImageCaptureProgressInformation
GO


CREATE PROCEDURE WiMiImageCaptureProgressInformation
	@sessName AS NVARCHAR(64)
AS
BEGIN
	SELECT	r.StepNumber,
			r.Description,
			LOWER(r.Status) AS Status,
			r.StatusMessage
	FROM	RolloutStatus as r, RolloutStatusType as t
	WHERE	r.SessionName = @sessName
				AND r.RolloutStatusTypeID = t.RolloutStatusTypeID
				AND t.[Name] = 'ComputerImageCapture'
				ORDER BY StepNumber
END
GO

CopyPermission 'WiMiImageCaptureProgressInformation', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiImageCaptureProgressSummary
 *	Input:
 * 	- @FromDate.
 *	- @TillDate.
 *
 *	Returns:
 *	- State, Total
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiImageCaptureProgressSummary' AND xtype = 'P'
)
        DROP PROCEDURE WiMiImageCaptureProgressSummary
GO

CREATE PROCEDURE [WiMiImageCaptureProgressSummary]
	@FromDate	datetime,
	@TillDate	datetime
AS
	BEGIN
		SELECT	ms.State, 
			COUNT(ms.SessionName) as Total
		FROM	WiMiImageCaptureStateByComputer as ms
		WHERE	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0
		GROUP BY State
		ORDER BY State

	END

GO

CopyPermission 'WiMiImageCaptureProgressSummary', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiDataCaptureProgress
 *	Input:
 *		@FromDate, @TillDate, @state
 *
 *	Returns:
 *		ComputerID, ComputerName, OUDN, State
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiDataCaptureProgress' AND xtype = 'P'
)
        DROP PROCEDURE WiMiDataCaptureProgress
GO

CREATE PROCEDURE [WiMiDataCaptureProgress]
	@FromDate	DATETIME,
	@TillDate	DATETIME,
	@state VARCHAR(50) = NULL
AS
BEGIN

	IF @state IS NULL
		SET @state = '%'
	
	SELECT 
		ms.SessionName,
		ms.State, 
		c.ComputerID,
		ISNULL(c.ComputerCN, ms.SessionName) AS [ComputerName], -- current name
		dbo.OUName(c.ComputerOUID) AS [OUDN],
		ms.LastStep,
		ms.LastStepDescription,
		ms.StepCount,
		ms.LastDateTime,
		ms.DataStoreLocation,
		ms.CaptureDateTime
	FROM		
		WiMiDataCaptureStateByComputer AS ms
		LEFT OUTER JOIN 	
			(Computer AS c 
				LEFT OUTER JOIN 
				(Namemap AS map
					INNER JOIN Domain AS d1
					ON map.Domain = d1.OrganizationID
					INNER JOIN Domain AS d2
					ON map.newDomain = d2.OrganizationID
				)
				ON c.ComputerID = map.currentID		
			) -- name-mapping for pre and post rollout computer names
		ON ms.ComputerID = c.ComputerID
	WHERE	ms.State LIKE @state
	  AND	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
	  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0

END
GO


CopyPermission 'WiMiDataCaptureProgress', 'mgsOSBreakdown'
GO

/*
 * $ Exp $
 *
 * DESCRIPTION: Stored Procedure: WiMiDataCaptureProgressInformation
 *	Input:
 *		@sessName
 *
 *	Returns:
 *		PackageName, Version, PolicyAction, FailReason, PackageFullName
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiDataCaptureProgressInformation' AND xtype = 'P'
)
        DROP PROCEDURE WiMiDataCaptureProgressInformation
GO


CREATE PROCEDURE WiMiDataCaptureProgressInformation
	@sessName AS NVARCHAR(64)
AS
BEGIN
	SELECT	r.StepNumber,
			r.Description,
			LOWER(r.Status) AS Status,
			r.StatusMessage
	FROM	RolloutStatus as r, RolloutStatusType as t
	WHERE	r.SessionName = @sessName
				AND r.RolloutStatusTypeID = t.RolloutStatusTypeID
				AND t.[Name] = 'ComputerDataCapture'
				ORDER BY StepNumber
END
GO

CopyPermission 'WiMiDataCaptureProgressInformation', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiDataCaptureProgressSummary
 *	Input:
 * 	- @FromDate.
 *	- @TillDate.
 *
 *	Returns:
 *	- State, Total
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiDataCaptureProgressSummary' AND xtype = 'P'
)
        DROP PROCEDURE WiMiDataCaptureProgressSummary
GO

CREATE PROCEDURE [WiMiDataCaptureProgressSummary]
	@FromDate	datetime,
	@TillDate	datetime
AS
	BEGIN
		SELECT	ms.State, 
			COUNT(ms.SessionName) as Total
		FROM	WiMiDataCaptureStateByComputer as ms
		WHERE	DATEDIFF(day, ms.LastDateTime, @FromDate) <= 0
		  AND	DATEDIFF(day, ms.LastDateTime, @TillDate) >= 0
		GROUP BY ms.State
		ORDER BY ms.State

	END

GO

CopyPermission 'WiMiDataCaptureProgressSummary', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: RolloutGroupEntry
 *	Input:
 * 	- @groupName: name of group Default: '%' (= all groups)
 *	- @parentID: parentID of group. Default: 0 i.e. represents Ghost Server
 *
 *	Returns:
 *	- GroupID, GroupName, ParentID,	Source
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'RolloutGroupEntry' AND xtype = 'P'
)
        DROP PROCEDURE RolloutGroupEntry
GO
 
CREATE PROCEDURE RolloutGroupEntry
	@groupName nvarchar(256) = N'%',
	@parentID int = 0 --represents base or Ghost Server
AS

	SELECT 
		GroupID,
		GroupName,
		ParentID,
		Source
	FROM RolloutGroup rs
	WHERE GroupName LIKE @groupName
		AND ParentID = @parentID --when 0; its base ie. Ghost Server

GO

CopyPermission 'RolloutGroupEntry', 'mgsOSBreakdown'
GO 

/*
 *
 * DESCRIPTION: Stored Procedure: GhostServerEntry
 *	Input:
 * 	- @serverMAC: MAC Address of Ghost Server
 *
 *	Returns:
 *	- GhostServerID, GroupID, ServerName, 
 *	- PhysicalAddress, DomainName, LastUpdateDateTime
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'GhostServerEntry' AND xtype = 'P'
)
        DROP PROCEDURE GhostServerEntry
GO

CREATE PROCEDURE GhostServerEntry
	@serverMAC varchar(64) -- Ghost Server should always have a MAC address
AS
SELECT 
	gs.GhostServerID,
	gs.GroupID,
	gs.ServerName,
	gs.PhysicalAddress,
	gs.DomainName,
	gs.LastUpdateDateTime

FROM GhostServer gs
WHERE	gs.PhysicalAddress LIKE @serverMAC	

GO  

CopyPermission 'GhostServerEntry', 'mgsOSBreakdown'
GO 

/*
 *
 * DESCRIPTION: Stored Procedure: RolloutGroupGhostComputerEntry
 *	Input:
 *	- @groupID: GroupID of a group
 * 	- @serverMAC: MAC Address of computer in the group
 *
 *	Returns:
 *	- GroupID, ComputerName, PhysicalAddress, IsResolved
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'RolloutGroupGhostComputerEntry' AND xtype = 'P'
)
        DROP PROCEDURE RolloutGroupGhostComputerEntry
GO

CREATE PROCEDURE RolloutGroupGhostComputerEntry
	@groupID int, -- 
	@compMAC varchar(64) = '%'
AS
	SELECT 
		rc.GroupID,
		rc.ComputerName,
		rc.PhysicalAddress,
		rc.IsResolved

	FROM RolloutGroupToGhostComputer rc
	WHERE	rc.GroupID = @groupID	
		AND rc.PhysicalAddress LIKE @compMAC
		
GO 

CopyPermission 'RolloutGroupGhostComputerEntry', 'mgsOSBreakdown'
GO 

/*
 *
 * DESCRIPTION: Stored Procedure: ResolveGhostComputer
 * - resolves computers from ghost based on ManageSoft Computer
 * entries
 *
 *	Input:
 *	- none
 *
 *	Returns:
 *	- none
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'ResolveGhostComputer' AND xtype = 'P'
)
        DROP PROCEDURE ResolveGhostComputer
GO

CREATE PROCEDURE ResolveGhostComputer
AS
	DECLARE @memberType int
	SELECT @memberType = TargetTypeID FROM TargetType WHERE TargetTypeName = 'Computer'

	--|||||||||||||||||||||||||||||||||||||||||||||
	-- Create New entries in RolloutGroupMember
	--|||||||||||||||||||||||||||||||||||||||||||||
	
	--Only using MAC address as Ghost is a reliable source
	INSERT INTO RolloutGroupMember
	SELECT DISTINCT
		rc.GroupID,
		ho.ComputerID as MemberID,
		@memberType as MemberType
	FROM 	RolloutGroupToGhostComputer as rc,
		HardwareObject as ho,
		HardwareProperty as hp,
		HardwareValue as hv
	WHERE	ho.HardwareObjectID = hv.HardwareObjectID
		AND hv.HardwarePropertyID = hp.HardwarePropertyID
		AND hp.Property = 'MACAddress'		
		AND hv.Value = rc.PhysicalAddress
		AND rc.IsResolved = 0 --Not resolved yet
		AND NOT EXISTS (
			SELECT * 
			FROM RolloutGroupMember 
			WHERE
				GroupID = rc.GroupID 
				AND MemberID = ho.ComputerID
				AND MemberType = @memberType
			) -- to maintain unique rows
		

	UPDATE RolloutGroupToGhostComputer
		SET IsResolved = 1
	FROM	RolloutGroupToGhostComputer as rc,
		HardwareObject as ho,
		HardwareProperty as hp,
		HardwareValue as hv,
		RolloutGroupMember as rm
	WHERE	ho.HardwareObjectID = hv.HardwareObjectID
		AND hv.HardwarePropertyID = hp.HardwarePropertyID
		AND hp.Property = 'MACAddress'		
		AND hv.Value = rc.PhysicalAddress
		AND ho.ComputerID = rm.MemberID
		AND rm.GroupID = rc.GroupID
		AND rc.IsResolved = 0 -- Not resolved yet

	--|||||||||||||||||||||||||||||||||||||||||||||
	-- Delete /Update Old entries based on changes
	-- in ManageSoft tables i.e. Computer and 
	-- HardwareProperty.
	--|||||||||||||||||||||||||||||||||||||||||||||
			
	--Delete from RolloutGroupMember table if entry not in Computer table 
	DELETE RolloutGroupMember FROM RolloutGroupMember
		WHERE NOT EXISTS
				(SELECT * FROM Computer WHERE ComputerID = MemberID)
	
	--Update if entry exists in MAC list but not in HardwareProperty			
	UPDATE RolloutGroupToGhostComputer SET IsResolved = 0
		FROM RolloutGroupToGhostComputer as rc
		WHERE IsResolved = 1
			AND NOT EXISTS (
				SELECT *
				FROM	HardwareProperty as hp,
					HardwareValue as hv
				WHERE	hv.HardwarePropertyID = hp.HardwarePropertyID
					AND hp.Property = 'MACAddress'		
					AND hv.Value = rc.PhysicalAddress
			)

GO

CopyPermission 'ResolveGhostComputer', 'mgsOSBreakdown'
GO

/*
 *
 * DESCRIPTION: Stored Procedure: RemoveGhostComputer
 * - removes computers from ghost based on ManageSoft Computer
 * entries
 *
 *	Input:
 *	- none
 *
 *	Returns:
 *	- none
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'RemoveGhostComputer' AND xtype = 'P'
)
        DROP PROCEDURE RemoveGhostComputer
GO

CREATE PROCEDURE RemoveGhostComputer
	@groupID int,
	@compMAC varchar(64)
AS
	
	-- Delete from RolloutGroupToGhostComputer table
	DELETE	RolloutGroupToGhostComputer
	WHERE	GroupID = @groupID
		AND	PhysicalAddress = @compMAC
	
	DECLARE @memberType int
	SELECT @memberType = TargetTypeID FROM TargetType WHERE TargetTypeName = 'Computer'
	
	-- Delete from RolloutGroupMember table
	DELETE	RolloutGroupMember
	FROM	RolloutGroupMember, HardwareObject, HardwareValue, HardwareProperty
	WHERE	RolloutGroupMember.MemberID = HardwareObject.ComputerID
		AND	HardwareObject.HardwareObjectID = HardwareValue.HardwareObjectID
		AND	HardwareValue.HardwarePropertyID = HardwareProperty.HardwarePropertyID
		AND	HardwareProperty.Property = 'MACAddress'
		AND	HardwareValue.Value = @compMAC

GO

CopyPermission 'RemoveGhostComputer', 'mgsOSBreakdown'
GO

/*
 *
 * DESCRIPTION: Stored Procedure: RemoveGhostGroup
 * - removes ghost groups from ghost based on ManageSoft Computer
 * entries
 *
 *	Input:
 *	- none
 *
 *	Returns:
 *	- none
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'RemoveGhostGroup' AND xtype = 'P'
)
        DROP PROCEDURE RemoveGhostGroup
GO

CREATE PROCEDURE RemoveGhostGroup
	@groupID int
AS
	-- Delete from RemoveGhostGroup table
	DELETE	RolloutGroup
	WHERE	GroupID = @groupID
GO

CopyPermission 'RemoveGhostGroup', 'mgsOSBreakdown'
GO
/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: NameMapDelete
 *	Input:
 * 	- @computerName: name of the computer to remove from the mapping
 *	- @computerDomain: domain the computerName
 *
 *	Returns:
 *	- nothing - removes the name mapping from the table
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapDelete' AND xtype = 'P'
)
        DROP PROCEDURE NameMapDelete
GO

CREATE PROCEDURE [NameMapDelete]
	@id int
AS

	IF EXISTS(SELECT * 
		FROM NameMap
		WHERE CurrentId = @id)
	BEGIN
		DELETE FROM NameMap
		WHERE CurrentId = @id
	END

GO

CopyPermission 'NameMapDelete', 'mgsOSBreakdown'
GO 

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapRemove' AND xtype = 'P'
)
        DROP PROCEDURE NameMapRemove
GO

CREATE PROCEDURE [NameMapRemove]
	@newName nvarchar(64),
	@newDomain nvarchar(100),
	@newOU nvarchar(512)
AS
	DECLARE @DomainID AS int
	DECLARE @newOUID AS int

	SELECT @DomainID = OrganizationID FROM Domain
	WHERE DN = @newDomain

	SELECT @newOUID = OrganizationID FROM Organization
	WHERE RDN = @newOU 
	  AND DomainID = @DomainID
	
	IF EXISTS(SELECT * 
		FROM NameMap
		WHERE newname = @newName
		  AND newDomain = @DomainID
		  AND newOU = @newOUID
		)
	BEGIN
		DELETE FROM NameMap
		WHERE newname = @newName
		  AND newDomain = @DomainID
		  AND newOU = @newOUID
	END

GO


CopyPermission 'NameMapRemove', 'mgsOSBreakdown'
GO 

/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: NameMapUpdate
 *	Input:
 * 	- @computerName: name of the computer to update
 * 	- @computerDomain: domain of the computer to update
 * 	- @newName: new name for the computer
 * 	- @newDomain: new domain for the computer
 *
 *	Returns:
 	- nothing. updates/adds rows to the NameMap table
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapUpdate' AND xtype = 'P'
)
        DROP PROCEDURE NameMapUpdate
GO

CREATE PROCEDURE [NameMapUpdate]
	@computerName nvarchar(64),
	@computerDomain nvarchar(100),
	@newName nvarchar(64),
	@newDomain nvarchar(100),
	@id int,
	@newOU nvarchar(512),
	@updatedNewName nvarchar(64) -- used to rename computers that have no @id
AS
	DECLARE @DomainID AS int
	DECLARE @newDomainID AS int
	DECLARE @newOUID AS int

	SELECT @DomainID = OrganizationID FROM Domain
	WHERE DN = @computerDomain

	SELECT @newDomainID = OrganizationID FROM Domain
	WHERE DN = @newDomain
	
	SELECT @newOUID = OrganizationID FROM Organization
	WHERE RDN = @newOU 
	  AND DomainID = @newDomainID

	-- this condition updates a computer that exists in the 
	-- computer table (and therefore in Active Directory)
	IF EXISTS(SELECT * 
		FROM NameMap as nm, Domain as d
		WHERE nm.CurrentID = @id
		  AND @id IS NOT NULL)
		BEGIN
			UPDATE NameMap
			SET newName = @newName,
			    newDomain = @newDomainID,
			    newOU = NULL
			WHERE CurrentId = @id
		END
	-- this condition updates name mappings for new computers that
	-- do not exist in the Computer table or in Active Directory
	ELSE IF EXISTS (SELECT * 
		FROM NameMap as nm
		WHERE nm.[name] IS NULL
		  AND nm.domain IS NULL
		  AND nm.CurrentID IS NULL
		  AND nm.newOU = @newOUID
		  AND nm.newName = @newName
		  AND nm.newDomain = @newDomainID)
		BEGIN
			UPDATE NameMap
			SET newName = @updatedNewName
			WHERE [name] IS NULL
			AND domain IS NULL
			AND CurrentID IS NULL
			AND newOU = @newOUID
			AND newName = @newName
			AND newDomain = @newDomainID
		END
	-- This final case inserts new name mappings into the table
	--
	ELSE
		BEGIN
			INSERT INTO NameMap
			(CurrentId, [name], domain, newName, newDomain, newOU)
			VALUES
			(@id, @computerName, @DomainID, @newName, @newDomainID, @newOUID)
		END

GO

CopyPermission 'NameMapUpdate', 'mgsOSBreakdown'
GO 

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapUpdateWithProperties' AND xtype = 'P'
)
        DROP PROCEDURE NameMapUpdateWithProperties
GO

CREATE PROCEDURE [NameMapUpdateWithProperties]
	@computerName nvarchar(64),
	@computerDomain nvarchar(100),
	@newName nvarchar(64),
	@newDomain nvarchar(100),
	@id int,
	@ipAddress nvarchar(32),
	@macAddress nvarchar(32),
	@newOU nvarchar(512)
AS
	DECLARE @DomainID AS int
	DECLARE @newDomainID AS int
	DECLARE @newOUID AS int

	SELECT @DomainID = OrganizationID FROM Domain
	WHERE DN = @computerDomain

	SELECT @newDomainID = OrganizationID FROM Domain
	WHERE DN = @newDomain
	
	SELECT @newOUID = OrganizationID FROM Organization
	WHERE RDN = @newOU 
	  AND DomainID = @newDomainID

	-- this condition updates a computer that exists in the 
	-- computer table (and therefore in Active Directory)
	IF EXISTS(SELECT * 
		FROM NameMap as nm, Domain as d
		WHERE nm.CurrentID = @id
		  AND @id IS NOT NULL)
		BEGIN
			UPDATE NameMap
			SET ipAddress = @ipAddress,
			    macAddress = @macAddress,
			    newOU = NULL
			WHERE CurrentId = @id
		END
	-- this condition updates name mappings for new computers that
	-- do not exist in the Computer table or in Active Directory
	ELSE IF EXISTS (SELECT * 
		FROM NameMap as nm
		WHERE nm.[name] IS NULL
		  AND nm.domain IS NULL
		  AND nm.CurrentID IS NULL
		  AND nm.newOU = @newOUID
		  AND nm.newName = @newName
		  AND nm.newDomain = @newDomainID)
		BEGIN
			UPDATE NameMap
			SET ipAddress = @ipAddress,
			    macAddress = @macAddress
			WHERE [name] IS NULL
			AND domain IS NULL
			AND CurrentID IS NULL
			AND newOU = @newOUID
			AND newName = @newName
			AND newDomain = @newDomainID
		END
	-- This final case inserts new name mappings into the table
	--
	ELSE
		BEGIN
			INSERT INTO NameMap
			(CurrentId, [name], domain, newName, newDomain, ipAddress, macAddress, newOU)
			VALUES
			(@id, @computerName, @DomainID, @newName, @newDomainID, @ipAddress, @macAddress, @newOUID)
		END

GO

CopyPermission 'NameMapUpdateWithProperties', 'mgsOSBreakdown'
GO 



IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapLookupUpdateWithProperties' AND xtype = 'P'
)
        DROP PROCEDURE NameMapLookupUpdateWithProperties
GO

CREATE PROCEDURE [NameMapLookupUpdateWithProperties]
	@computerName nvarchar(64),
	@computerDomain nvarchar(100),
	@computerOU nvarchar(512),
	@newName nvarchar(64),
	@newDomain nvarchar(100),
	@ipAddress nvarchar(32),
	@macAddress nvarchar(32),
	@newOU nvarchar(512),
	@errorLevel int OUTPUT
AS
	DECLARE @DomainID AS int
	DECLARE @newDomainID AS int
	DECLARE @newOUID AS int
	DECLARE @id AS int
	SELECT @errorLevel = NULL

	SELECT @DomainID = OrganizationID FROM Domain
	WHERE DN = @computerDomain

	SELECT @newDomainID = OrganizationID FROM Domain
	WHERE DN = @newDomain
	
	SELECT @newOUID = OrganizationID FROM Organization
	WHERE RDN = @newOU 
	  AND DomainID = @newDomainID

	IF @computerOU IS NOT NULL
	BEGIN	
		SELECT	@id = ComputerID
		FROM	ComputerDirectory
		WHERE	DomainID = @DomainID
		AND	ComputerCN = @computerName
		AND	OURDN = @computerOU
		AND	DomainID IS NOT NULL
		AND	ComputerCN IS NOT NULL
		AND	OURDN IS NOT NULL
	END
	ELSE
	BEGIN
		SELECT	@id = ComputerID
		FROM	ComputerDirectory
		WHERE	DomainID = @DomainID
		AND	ComputerCN = @computerName
		AND	DomainID IS NOT NULL
		AND	ComputerCN IS NOT NULL
		AND	OURDN IS NOT NULL
	END

	-- the computer does not meet the rules 
	-- for being an old or new computer
	--	
	IF @id IS NULL AND @newOUID IS NULL
	BEGIN
		SELECT @errorLevel = 1 -- generic invalid row
		RETURN
	END

	-- this row should exist in the computer table
	-- because it has an old name specified	
	IF @computerName IS NOT NULL AND @id IS NULL
	BEGIN
		-- computer should exist, but doesn't
		SELECT @errorLevel = 2
		RETURN
	END
	
	-- This is not an error case, but we don't want to update the
	-- database if all we are doing is adding an existing 
	-- computer with no properties set.
	-- 
	IF @id IS NOT NULL 
		AND @macAddress IS NULL 
		AND @ipAddress IS NULL 
		AND @newName IS NULL
	BEGIN
		RETURN
	END

	-- this condition updates a computer that exists in the 
	-- computer table (and therefore in Active Directory)
	IF EXISTS(SELECT * 
		FROM NameMap as nm, Domain as d
		WHERE nm.CurrentID = @id
		  AND @id IS NOT NULL)
		BEGIN
			UPDATE NameMap
			SET ipAddress = @ipAddress,
			    macAddress = @macAddress,
			    newOU = NULL
			WHERE CurrentId = @id
		END
	-- this condition updates name mappings for new computers that
	-- do not exist in the Computer table or in Active Directory
	ELSE IF EXISTS (SELECT * 
		FROM NameMap as nm
		WHERE nm.[name] IS NULL
		  AND nm.domain IS NULL
		  AND nm.CurrentID IS NULL
		  AND nm.newOU = @newOUID
		  AND nm.newName = @newName
		  AND nm.newDomain = @newDomainID)
		BEGIN
			UPDATE NameMap
			SET ipAddress = @ipAddress,
			    macAddress = @macAddress
			WHERE [name] IS NULL
			AND domain IS NULL
			AND CurrentID IS NULL
			AND newOU = @newOUID
			AND newName = @newName
			AND newDomain = @newDomainID
		END
	-- This final case inserts new name mappings into the table
	--
	ELSE
		BEGIN
			-- set the new OUID to null if the computer exists in AD
			IF @id IS NOT NULL
			BEGIN
				SELECT @newOUID = NULL
			END
			INSERT INTO NameMap
			(CurrentId, [name], domain, newName, newDomain, ipAddress, macAddress, newOU)
			VALUES
			(@id, @computerName, @DomainID, @newName, @newDomainID, @ipAddress, @macAddress, @newOUID)
		END

GO

CopyPermission 'NameMapLookupUpdateWithProperties', 'mgsOSBreakdown'
GO 



/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: RolloutGroupGhostComputerEntry
 *	Input:
 *	- @groupID: GroupID of a group
 * 	- @serverMAC: MAC Address of computer in the group
 *
 *	Returns:
 *	- GroupID, ComputerName, PhysicalAddress, IsResolved
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */

-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'GetHardwareProperty' AND xtype = 'P'
)
        DROP PROCEDURE GetHardwareProperty
GO

CREATE PROCEDURE [GetHardwareProperty]
	@computerName nvarchar(64),
	@computerDomain nvarchar(100),
	@hardwareClass nvarchar(64),
	@hardwareProperty nvarchar(50)
AS
	SELECT hv.Value
	FROM	HardwareClass AS hc,			-- HW class names
		HardwareObject AS ho,
		HardwareProperty as hp,			-- Property types
		HardwareValue as hv,
		Computer c,
		Organization AS o,
		Domain AS d
	WHERE	hv.HardwarePropertyID = hp.HardwarePropertyID
	  AND	hp.Property = @hardwareProperty		-- Right property
	  AND	hv.HardwareObjectID = ho.HardwareObjectID
	  AND	ho.HardwareClassID = hc.HardwareClassID
	  AND	hc.Class = @hardwareClass		-- Right class
	  AND	ho.ComputerID = c.ComputerID
	  AND	c.ComputerCN = @computerName		-- Right computer
	  AND	c.ComputerOUID = o.OrganizationID
	  AND	o.DomainID = d.OrganizationID
	  AND	d.DN = @computerDomain			-- Right domain
GO

CopyPermission 'GetHardwareProperty', 'mgsOSBreakdown'
GO 


-- USE MANAGESOFT
GO


IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapDuplicate' AND xtype = 'P'
)
        DROP PROCEDURE NameMapDuplicate
GO

CREATE PROCEDURE [NameMapDuplicate]
	@computerName nvarchar(64),
	@computerDomain nvarchar(100)
AS

	DECLARE @newDomainID AS int

	SELECT @newDomainID = OrganizationID FROM Domain
	WHERE DN = @computerDomain

	(
	SELECT c.ComputerCN
	FROM Computer as c, Domain as d, Organization as o
	WHERE c.ComputerOUID = o.OrganizationID
	  AND o.DomainID = d.OrganizationID
	  AND c.ComputerCN = @computerName
	  AND o.DomainID = @newDomainID
	)
	UNION
	(
	SELECT nm.newName
	FROM NameMap as nm, Domain as d
	WHERE nm.newName = @computerName
	  AND d.DN = @computerDomain
	  AND nm.newDomain = d.OrganizationID
	)
	
GO

CopyPermission 'NameMapDuplicate', 'mgsOSBreakdown'
GO 


-- USE MANAGESOFT
GO


IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapCleanup' AND xtype = 'P'
)
        DROP PROCEDURE NameMapCleanup
GO

CREATE PROCEDURE [NameMapCleanup]
AS

	DELETE FROM NameMap
	WHERE CurrentId NOT IN
	(
		SELECT ComputerId FROM Computer
	)
	AND newOU IS NULL
	
GO

CopyPermission 'NameMapCleanup', 'mgsOSBreakdown'
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'NameMapLink' AND xtype = 'P'
)
        DROP PROCEDURE NameMapLink
GO
CREATE PROCEDURE [NameMapLink]
	@nameMapId int,
	@computerId int
AS
	UPDATE	NameMap
	SET	Name = NewName,
		Domain = NewDomain,
		CurrentID = @computerId,
		NewOU = NULL
	WHERE	ID = @nameMapId
GO

CopyPermission 'NameMapLink', 'mgsOSBreakdown'
GO

/*
 * $Header$
 *
 * DESCRIPTION: Stored Procedure: WiMiMWMPInstallerPackages
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 */
 
-- USE MANAGESOFT
GO

IF EXISTS (
        SELECT * FROM dbo.sysobjects
        WHERE [name] = 'WiMiInstallerPackages' AND xtype = 'P'
)
        DROP PROCEDURE WiMiInstallerPackages
GO
 
CREATE PROCEDURE WiMiInstallerPackages
	@pPackageFullName nvarchar(256)
AS
	SELECT PackageFullName FROM PackagePath
	WHERE PackageFullName LIKE @pPackageFullName
GO
