/*
 * $Id: imagelibrary.sql 101389 2011-11-25 01:51:25Z rlowery $
 *
 * Description:
 *
 * SQL Script to build the ManageSoft image tables on Microsoft SQL
 * Server.
 *
 * The steps performed by this script are:
 * 1. Create new database
 * 2. Create database table and initialiase data (skip if the table exists)
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 *
 * Copyright 2011 Flexera Software LLC
 */
USE ManageSoft
GO

-- Create OSImageFolder table
IF NOT EXISTS (
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE TABLE_NAME = 'OSImageFolder'
)
BEGIN
	-- Create table
	PRINT 'Creating OSImageFolder table'
	CREATE TABLE OSImageFolder
	(
		-- Auto-generated identity #
		OSImageFolderID INTEGER NOT NULL IDENTITY
			CONSTRAINT PK_OSImageFolder PRIMARY KEY NONCLUSTERED,

		-- GUID of image folder
		ImageFolderGUID BINARY(16) NULL DEFAULT(NULL),
			
		-- Path of ImageFolder
		ImageFolderPath INTEGER REFERENCES OSImageFolder(OSImageFolderID),
			
		-- Name of ImageFolder
		ImageFolderName NVARCHAR(256) NULL DEFAULT(NULL)
	);
	
	-- Create indices
	CREATE UNIQUE INDEX OSImageFolderByGUID
	ON OSImageFolder (ImageFolderGUID)
	CREATE UNIQUE INDEX OSImageFolderByPathName
	ON OSImageFolder (ImageFolderPath, ImageFolderName)
	CREATE INDEX OSImageFolderByPath
	ON OSImageFolder (ImageFolderPath)
END
ELSE
	PRINT 'Using existing OSImageFolder table'
GO

-- Create OSImage table
IF NOT EXISTS (
	SELECT *
	FROM INFORMATION_SCHEMA.TABLES
	WHERE TABLE_NAME = 'OSImage'
)
BEGIN
	-- Create table
	PRINT 'Creating OSImage table'
	CREATE TABLE OSImage
	(
		-- Auto-generated identity #
		OSImageID INTEGER NOT NULL IDENTITY
			CONSTRAINT PK_OSImage PRIMARY KEY NONCLUSTERED,

		-- GUID of image
		ImageGUID BINARY(16) NULL DEFAULT(NULL),
		
		-- GUID of image version
		ImageVersionGUID BINARY(16) NULL DEFAULT(NULL),
			
		-- Path of image
		ImagePath INTEGER NULL REFERENCES OSImageFolder(OSImageFolderID),
			
		-- Name of image
		ImageName NVARCHAR(256) NOT NULL,
		
		-- Version of image
		ImageVersion NVARCHAR(64) NOT NULL,
		
		-- Modify date and time of image
		ImportDateTime DATETIME NOT NULL,
		
		-- Operating system type
		OperatingSystem NVARCHAR(64) NULL DEFAULT(NULL),
		
		-- Type of image (unattend, sysprep)
		ImagingType NVARCHAR(64) NULL DEFAULT(NULL),
		
		-- File system of image
		FileSystem NVARCHAR(64) NULL DEFAULT(NULL),
		
		-- Size of image (in MB)
		ImageSize INTEGER NULL DEFAULT(NULL),
		
		-- Description of image
		Description NVARCHAR(256) NULL DEFAULT(NULL),
		
		-- Path of image in repository
		RepositoryPath NVARCHAR(256) NULL DEFAULT(NULL),

		-- Path of OS image file repository
		OSImageFile NVARCHAR(256) NULL DEFAULT(NULL),

		-- Whether or not the OSImage is active from the User Select Menu
		Active BIT Not NULL DEFAULT(1),

		-- The Image Command string
		ImageCommand NVARCHAR(256) NULL DEFAULT(NULL),

		-- The drive letter to use for the image
		ImageDrive NVARCHAR(16) NULL DEFAULT (NULL),

		-- The image index for WIM files
		ImageIndex INTEGER NULL DEFAULT(NULL)
		
	);
	
	-- Create indices
	CREATE UNIQUE INDEX OSImageByGUID
	ON OSImage (ImageGUID)
	CREATE UNIQUE INDEX OSImageByPathName
	ON OSImage (ImagePath, ImageName)
	CREATE INDEX OSImageByPath
	ON OSImage (ImagePath)
END
ELSE
	PRINT 'Using existing OSImage table'
GO
