/*
 * $Id: imagelibrary.sql 101389 2011-11-25 01:51:25Z rlowery $
 *
 * Description:
 *
 * SQL Script to build the ManageSoft image library stored procedures
 * on Microsoft SQL Server.
 *
 * The steps performed by this script are:
 * 1. Create new database
 * 2. Create database table and initialiase data (skip if the table exists)
 *
 * Protected by US patent 6,006,034; patents pending.
 * Copyright 2011 Flexera Software LLC
 * Reproduction, adaptation, or translation without prior permission
 * is prohibited.
 *
 * Copyright 2011 Flexera Software LLC
 */
USE ManageSoft
GO

-- Procedure for selecting an OS image folder
PRINT 'Creating procedure to select OS image folder'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderSelect' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderSelect];
GO
CREATE PROCEDURE [OSImageFolderSelect]
(
	@ImageFolderGUID binary(16)
)
AS
	SET NOCOUNT ON;
	SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
		COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
		FROM OSImageFolder AS A
		LEFT OUTER JOIN OSImageFolder AS B
		ON A.OSImageFolderID = B.ImageFolderPath
		LEFT OUTER JOIN OSImage AS C
		ON A.OSImageFolderID = C.ImagePath
		WHERE (A.ImageFolderGUID = @ImageFolderGUID)
		GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName;
GO

-- Procedure for selecting an OS image folder
PRINT 'Creating procedure to select an OS image folder'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderSelectID' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderSelectID];
GO
CREATE PROCEDURE [OSImageFolderSelectID]
(
	@OSImageFolderID int
)
AS
	SET NOCOUNT ON;
	SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
		COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
		FROM OSImageFolder AS A
		LEFT OUTER JOIN OSImageFolder AS B
		ON A.OSImageFolderID = B.ImageFolderPath
		LEFT OUTER JOIN OSImage AS C
		ON A.OSImageFolderID = C.ImagePath
		WHERE (A.OSImageFolderID = @OSImageFolderID)
		GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName;
GO

-- Procedure for selecting child OS image folders
PRINT 'Creating procedure to select child OS image folders'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderChildSelect' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderChildSelect];
GO
CREATE PROCEDURE [OSImageFolderChildSelect]
(
	@ImageFolderPath int = NULL
)
AS
	SET NOCOUNT ON;
	IF (@ImageFolderPath IS NULL)
		SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
			COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
			FROM OSImageFolder AS A
			LEFT OUTER JOIN OSImageFolder AS B
			ON A.OSImageFolderID = B.ImageFolderPath
			LEFT OUTER JOIN OSImage AS C
			ON A.OSImageFolderID = C.ImagePath
			WHERE (A.ImageFolderPath IS NULL)
			GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName
			ORDER BY A.ImageFolderName;
	ELSE
		SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
			COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
			FROM OSImageFolder AS A
			LEFT OUTER JOIN OSImageFolder AS B
			ON A.OSImageFolderID = B.ImageFolderPath
			LEFT OUTER JOIN OSImage AS C
			ON A.OSImageFolderID = C.ImagePath
			WHERE (A.ImageFolderPath = @ImageFolderPath)
			GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName
			ORDER BY A.ImageFolderName;
GO

-- Procedure for inserting an OS image folder
PRINT 'Creating procedure to insert an OS image folder'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderInsert' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderInsert];
GO
CREATE PROCEDURE [OSImageFolderInsert]
(
	@ImageFolderGUID binary(16),
	@ImageFolderPath int,
	@ImageFolderName nvarchar(256)
)
AS
	SET NOCOUNT OFF;
	INSERT INTO OSImageFolder (ImageFolderGUID, ImageFolderPath, ImageFolderName)
		VALUES (@ImageFolderGUID, @ImageFolderPath, @ImageFolderName);
	SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
		COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
		FROM OSImageFolder AS A
		LEFT OUTER JOIN OSImageFolder AS B
		ON A.OSImageFolderID = B.ImageFolderPath
		LEFT OUTER JOIN OSImage AS C
		ON A.OSImageFolderID = C.ImagePath
		WHERE (A.OSImageFolderID = @@IDENTITY)
		GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName;
GO

-- Procedure for updating an OS image folder
PRINT 'Creating procedure to update an OS image folder'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderUpdate' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderUpdate];
GO
CREATE PROCEDURE [OSImageFolderUpdate]
(
	@ImageFolderGUID binary(16),
	@ImageFolderPath int,
	@ImageFolderName nvarchar(256),
	@Original_OSImageFolderID int,
	@Original_ImageFolderGUID binary(16),
	@Original_ImageFolderName nvarchar(256),
	@Original_ImageFolderPath int,
	@OSImageFolderID int
)
AS
	SET NOCOUNT OFF;
	UPDATE OSImageFolder
		SET ImageFolderGUID = @ImageFolderGUID, ImageFolderPath = @ImageFolderPath, ImageFolderName = @ImageFolderName
		WHERE (OSImageFolderID = @Original_OSImageFolderID)
		AND (ImageFolderGUID = @Original_ImageFolderGUID OR @Original_ImageFolderGUID IS NULL AND ImageFolderGUID IS NULL)
		AND (ImageFolderName = @Original_ImageFolderName OR @Original_ImageFolderName IS NULL AND ImageFolderName IS NULL)
		AND (ImageFolderPath = @Original_ImageFolderPath OR @Original_ImageFolderPath IS NULL AND ImageFolderPath IS NULL);
	SELECT A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName,
		COUNT(B.ImageFolderPath) AS ChildImageFolderCount, COUNT(C.ImagePath) AS ChildImageCount
		FROM OSImageFolder AS A
		LEFT OUTER JOIN OSImageFolder AS B
		ON A.OSImageFolderID = B.ImageFolderPath
		LEFT OUTER JOIN OSImage AS C
		ON A.OSImageFolderID = C.ImagePath
		WHERE (A.OSImageFolderID = @OSImageFolderID)
		GROUP BY A.OSImageFolderID, A.ImageFolderGUID, A.ImageFolderPath, A.ImageFolderName;
GO

-- Procedure for deleting an OS image folder
PRINT 'Creating procedure to delete an OS image folder'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageFolderDelete' AND xtype = 'P')
	DROP PROCEDURE [OSImageFolderDelete];
GO

CREATE PROCEDURE [OSImageFolderDelete]
(
	@Original_OSImageFolderID int,
	@Original_ImageFolderGUID binary(16),
	@Original_ImageFolderName nvarchar(256),
	@Original_ImageFolderPath int
)
AS
	SET NOCOUNT OFF;
	DELETE FROM OSImageFolder
		WHERE (OSImageFolderID = @Original_OSImageFolderID)
		AND (ImageFolderGUID = @Original_ImageFolderGUID OR @Original_ImageFolderGUID IS NULL AND ImageFolderGUID IS NULL)
		AND (ImageFolderName = @Original_ImageFolderName OR @Original_ImageFolderName IS NULL AND ImageFolderName IS NULL)
		AND (ImageFolderPath = @Original_ImageFolderPath OR @Original_ImageFolderPath IS NULL AND ImageFolderPath IS NULL);
GO

-- Procedure for selecting an OS image
PRINT 'Creating procedure to select an OS image'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageSelect' AND xtype = 'P')
	DROP PROCEDURE [OSImageSelect];
GO

CREATE PROCEDURE [OSImageSelect]
(
	@ImageGUID binary(16)
)
AS
	SET NOCOUNT ON;
	SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
		ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive,
		ImageIndex
		FROM OSImage WHERE (ImageGUID = @ImageGUID);
GO

-- Procedure for selecting an OS image
PRINT 'Creating procedure to select an OS image'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageSelectID' AND xtype = 'P')
	DROP PROCEDURE [OSImageSelectID];
GO
CREATE PROCEDURE [OSImageSelectID]
(
	@OSImageID int
)
AS
	SET NOCOUNT ON;
	SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
		ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive,
		ImageIndex
		FROM OSImage WHERE (OSImageID = @OSImageID);
GO

-- Procedure for selecting child OS images
PRINT 'Creating procedure to select child OS images'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageChildSelect' AND xtype = 'P')
	DROP PROCEDURE [OSImageChildSelect];
GO
CREATE PROCEDURE [OSImageChildSelect]
(
	@ImagePath int = NULL
)
AS
	SET NOCOUNT ON;
	IF (@ImagePath IS NULL)
		SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
			ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive,
			ImageIndex
			FROM OSImage
			WHERE (ImagePath IS NULL)
			ORDER BY ImageName;
	ELSE
		SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
			ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive,
			ImageIndex
			FROM OSImage
			WHERE (ImagePath = @ImagePath)
			ORDER BY ImageName;
GO

-- Procedure for inserting an OS image
PRINT 'Creating procedure to insert an OS image'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageInsert' AND xtype = 'P')
	DROP PROCEDURE [OSImageInsert];
GO
CREATE PROCEDURE [OSImageInsert]
(
	@ImageGUID binary(16),
	@ImageVersionGUID binary(16),
	@ImagePath int,
	@ImageName nvarchar(256),
	@ImageVersion nvarchar(64),
	@ImportDateTime datetime,
	@OperatingSystem nvarchar(64),
	@ImagingType nvarchar(64),
	@FileSystem nvarchar(64),
	@ImageSize int,
	@Description nvarchar(256),
	@RepositoryPath nvarchar(256),
	@OSImageFile nvarchar(256),
	@Active bit,
	@ImageCommand nvarchar(256),
	@ImageDrive nvarchar(16),
	@ImageIndex int
)
AS
	SET NOCOUNT OFF;
	INSERT INTO OSImage (ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
		ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive, ImageIndex)
		VALUES (@ImageGUID, @ImageVersionGUID, @ImagePath, @ImageName, @ImageVersion, @ImportDateTime, @OperatingSystem,
		@ImagingType, @FileSystem, @ImageSize, @Description, @RepositoryPath, @OSImageFile, @Active, @ImageCommand, @ImageDrive,
		@ImageIndex);
	SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
		ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive, ImageIndex
		FROM OSImage
		WHERE (OSImageID = @@IDENTITY);
GO

-- Procedure for updating an OS image
PRINT 'Creating procedure to update an OS image'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageUpdate' AND xtype = 'P')
	DROP PROCEDURE [OSImageUpdate];
GO
CREATE PROCEDURE [OSImageUpdate]
(
	@ImageGUID binary(16),
	@ImageVersionGUID binary(16),
	@ImagePath int,
	@ImageName nvarchar(256),
	@ImageVersion nvarchar(64),
	@ImportDateTime datetime,
	@OperatingSystem nvarchar(64),
	@ImagingType nvarchar(64),
	@FileSystem nvarchar(64),
	@ImageSize int,
	@Description nvarchar(256),
	@RepositoryPath nvarchar(256),
	@OSImageFile nvarchar(256),
	@Active bit,
	@ImageCommand nvarchar(256),
	@ImageDrive nvarchar(16),
	@ImageIndex int,
	@Original_OSImageID int,
	@Original_Description nvarchar(256),
	@Original_RepositoryPath nvarchar(256),
	@Original_FileSystem nvarchar(64),
	@Original_ImageGUID binary(16),
	@Original_ImageVersionGUID binary(16),
	@Original_ImageName nvarchar(256),
	@Original_ImagePath int,
	@Original_ImageSize int,
	@Original_ImageVersion nvarchar(64),
	@Original_ImagingType nvarchar(64),
	@Original_ImportDateTime datetime,
	@Original_OperatingSystem nvarchar(64),
	@Original_OSImageFile nvarchar(256),
	@Original_Active bit,
	@Original_ImageCommand nvarchar(256),
	@Original_ImageDrive nvarchar(16),
	@Original_ImageIndex int,
	@OSImageID int
)
AS
	SET NOCOUNT OFF;
	UPDATE OSImage
		SET ImageGUID = @ImageGUID, ImageVersionGUID = @ImageVersionGUID, ImagePath = @ImagePath, ImageName = @ImageName,
		ImageVersion = @ImageVersion, ImportDateTime = @ImportDateTime, OperatingSystem = @OperatingSystem,
		ImagingType = @ImagingType, FileSystem = @FileSystem, ImageSize = @ImageSize, Description = @Description, RepositoryPath = @RepositoryPath, OSImageFile = @OSImageFile, Active = @Active, ImageCommand = @ImageCommand, ImageDrive = @ImageDrive, ImageIndex = @ImageIndex
		WHERE (OSImageID = @Original_OSImageID)
		AND (Description = @Original_Description OR @Original_Description IS NULL AND Description IS NULL)
		AND (RepositoryPath = @Original_RepositoryPath OR @Original_RepositoryPath IS NULL AND RepositoryPath IS NULL)
		AND (OSImageFile = @Original_OSImageFile OR @Original_OSImageFile IS NULL AND OSImageFile IS NULL)
		AND (Active = @Original_Active OR @Original_Active IS NULL AND Active IS NULL)
		AND (ImageCommand = @Original_ImageCommand OR @Original_ImageCommand IS NULL AND ImageCommand IS NULL)
		AND (ImageDrive = @Original_ImageDrive OR @Original_ImageDrive IS NULL AND ImageDrive IS NULL)
		AND (ImageIndex = @Original_ImageIndex OR @Original_ImageIndex IS NULL AND ImageIndex IS NULL)
		AND (FileSystem = @Original_FileSystem OR @Original_FileSystem IS NULL AND FileSystem IS NULL)
		AND (ImageGUID = @Original_ImageGUID OR @Original_ImageGUID IS NULL AND ImageGUID IS NULL)
		AND (ImageVersionGUID = @Original_ImageVersionGUID OR @Original_ImageVersionGUID IS NULL AND ImageVersionGUID IS NULL)
		AND (ImageName = @Original_ImageName)
		AND (ImagePath = @Original_ImagePath OR @Original_ImagePath IS NULL AND ImagePath IS NULL)
		AND (ImageSize = @Original_ImageSize OR @Original_ImageSize IS NULL AND ImageSize IS NULL)
		AND (ImageVersion = @Original_ImageVersion)
		AND (ImagingType = @Original_ImagingType OR @Original_ImagingType IS NULL AND ImagingType IS NULL)
		AND (ImportDateTime = @Original_ImportDateTime)
		AND (OperatingSystem = @Original_OperatingSystem OR @Original_OperatingSystem IS NULL AND OperatingSystem IS NULL);
	SELECT OSImageID, ImageGUID, ImageVersionGUID, ImagePath, ImageName, ImageVersion, ImportDateTime, OperatingSystem,
		ImagingType, FileSystem, ImageSize, Description, RepositoryPath, OSImageFile, Active, ImageCommand, ImageDrive, ImageIndex
		FROM OSImage
		WHERE (OSImageID = @OSImageID);
GO

-- Procedure for deleting an OS image
PRINT 'Creating procedure to delete an OS image'
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'OSImageDelete' AND xtype = 'P')
	DROP PROCEDURE [OSImageDelete];
GO
CREATE PROCEDURE [OSImageDelete]
(
	@Original_OSImageID int,
	@Original_Description nvarchar(256),
	@Original_RepositoryPath nvarchar(256),
	@Original_FileSystem nvarchar(64),
	@Original_ImageGUID binary(16),
	@Original_ImageVersionGUID binary(16),
	@Original_ImageName nvarchar(256),
	@Original_ImagePath int,
	@Original_ImageSize int,
	@Original_ImageVersion nvarchar(64),
	@Original_ImagingType nvarchar(64),
	@Original_ImportDateTime datetime,
	@Original_OperatingSystem nvarchar(64),
	@Original_OSImageFile nvarchar(256),
	@Original_Active bit,
	@Original_ImageCommand nvarchar(256),
	@Original_ImageDrive nvarchar(16),
	@Original_ImageIndex int
)
AS
	SET NOCOUNT OFF;
	DELETE FROM OSImage
		WHERE (OSImageID = @Original_OSImageID)
		AND (Description = @Original_Description OR @Original_Description IS NULL AND Description IS NULL)
		AND (RepositoryPath = @Original_RepositoryPath OR @Original_RepositoryPath IS NULL AND RepositoryPath IS NULL)
		AND (OSImageFile = @Original_OSImageFile OR @Original_OSImageFile IS NULL AND OSImageFile IS NULL)
		AND (Active = @Original_Active OR @Original_Active IS NULL AND Active IS NULL)
		AND (ImageCommand = @Original_ImageCommand OR @Original_ImageCommand IS NULL AND ImageCommand IS NULL)
		AND (ImageDrive = @Original_ImageDrive OR @Original_ImageDrive IS NULL AND ImageDrive IS NULL)
		AND (ImageIndex = @Original_ImageIndex OR @Original_ImageIndex IS NULL AND ImageIndex IS NULL)
		AND (FileSystem = @Original_FileSystem OR @Original_FileSystem IS NULL AND FileSystem IS NULL)
		AND (ImageGUID = @Original_ImageGUID OR @Original_ImageGUID IS NULL AND ImageGUID IS NULL)
		AND (ImageVersionGUID = @Original_ImageVersionGUID OR @Original_ImageVersionGUID IS NULL AND ImageVersionGUID IS NULL)
		AND (ImageName = @Original_ImageName)
		AND (ImagePath = @Original_ImagePath OR @Original_ImagePath IS NULL AND ImagePath IS NULL)
		AND (ImageSize = @Original_ImageSize OR @Original_ImageSize IS NULL AND ImageSize IS NULL)
		AND (ImageVersion = @Original_ImageVersion)
		AND (ImagingType = @Original_ImagingType OR @Original_ImagingType IS NULL AND ImagingType IS NULL)
		AND (ImportDateTime = @Original_ImportDateTime)
		AND (OperatingSystem = @Original_OperatingSystem OR @Original_OperatingSystem IS NULL AND OperatingSystem IS NULL);
GO

